/****************************************************************************
 *   Copyright (C) 2009 by Claas Anders "CaScAdE" Rathje                    *
 *   admiralcascade@gmail.com                                               *
 *   Project-URL: http://www.mylifesucks.de/oss/c-osd/                      *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License.         *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program; if not, write to the                          *
 *   Free Software Foundation, Inc.,                                        *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 ****************************************************************************/

#define baud 57600

#define RXD_BUFFER_LEN		150
#define TXD_BUFFER_LEN		150

extern volatile uint8_t rxd_buffer_locked;
extern volatile uint8_t rxd_buffer[RXD_BUFFER_LEN];
extern volatile uint8_t txd_buffer[TXD_BUFFER_LEN];
extern volatile uint8_t ReceivedBytes;
extern volatile uint8_t *pRxData;
extern volatile uint8_t RxDataLen;

extern 

/**
 * init usart1
 */
void usart1_init();

/**
 * disable the txd pin of usart1
 */
void usart1_DisableTXD(void);

/**
 * enable the txd pin of usart1
 */
void usart1_EnableTXD(void);

/**
 * send a <string> throught usart1
 */
void usart1_puts(char*);

/**
 * receive data through usart1
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=FlightCtrl&path=%2Fbranches%2FV0.72p+Code+Redesign+killagreg%2Fuart0.c
 */
ISR(SIG_USART1_RECV);

/**
 * Decode the recevied Buffer
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=FlightCtrl&path=%2Ftags%2FV0.72p%2Fuart.c
 */
void Decode64(void);

/**
 * request Data through USART in special MK format by adding checksum and
 * encode data in modified Base64
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=FlightCtrl&path=%2Ftags%2FV0.72p%2Fuart.c
 */
void sendMKData(unsigned char, unsigned char, unsigned char*, unsigned char);

/**
 * short script to directly send a request thorugh usart including en- and disabling it
 * where <address> is the address of the receipient, <label> is which data set to request
 * and <ms> represents the milliseconds delay between data
 */
void usart1_request_mk_data(uint8_t, char, uint8_t);
