/****************************************************************************
 *   Copyright (C) 2009 by Claas Anders "CaScAdE" Rathje                    *
 *   admiralcascade@gmail.com                                               *
 *   Project-URL: http://www.mylifesucks.de/oss/c-osd/                      *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License.         *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program; if not, write to the                          *
 *   Free Software Foundation, Inc.,                                        *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 ****************************************************************************/

/* ##########################################################################
 * gain some fake arm compat :)
 * ##########################################################################*/
#define u8 uint8_t
#define s8 int8_t
#define u16 uint16_t
#define s16 int16_t
#define u32 uint32_t
#define s32 int32_t

/*
 * FC Debug Struct
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=FlightCtrl&path=%2Ftags%2FV0.72p%2Fuart.h
 */
typedef struct {
    uint8_t Digital[2];
    uint16_t Analog[32]; // Debugvalues
} __attribute__((packed)) DebugOut_t;

/*
 * NaviCtrl OSD Structs
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=NaviCtrl&path=%2Ftags%2FV0.15c%2Fuart1.h
 */
typedef struct {
    s32 Longitude; // in 1E-7 deg
    s32 Latitude; // in 1E-7 deg
    s32 Altitude; // in mm
    u8 Status; // validity of data
} __attribute__((packed)) GPS_Pos_t;

typedef struct {
    s16 Distance; // distance to target in cm
    s16 Bearing; // course to target in deg
} __attribute__((packed)) GPS_PosDev_t;

typedef struct {
	u8 Version;						// version of the data structure
	GPS_Pos_t CurrentPosition;		// see ubx.h for details
	GPS_Pos_t TargetPosition;
	GPS_PosDev_t TargetPositionDeviation;
	GPS_Pos_t HomePosition;
	GPS_PosDev_t HomePositionDeviation;
	u8  WaypointIndex;				// index of current waypoints running from 0 to WaypointNumber-1
	u8  WaypointNumber;				// number of stored waypoints
	u8  SatsInUse;					// number of satellites used for position solution
	s16 Altimeter; 					// hight according to air pressure
	s16 Variometer;					// climb(+) and sink(-) rate
	u16 FlyingTime;					// in seconds
	u8  UBat;						// Battery Voltage in 0.1 Volts
	u16 GroundSpeed;				// speed over ground in cm/s (2D)
	s16 Heading;					// current flight direction in  as angle to north
	s16	CompassHeading;				// current compass value in 
	s8  AngleNick;					// current Nick angle in 1
	s8  AngleRoll;					// current Rick angle in 1
	u8  RC_Quality;					// RC_Quality
	u8  MKFlags;					// Flags from FC
	u8  NCFlags;					// Flags from NC
	u8  Errorcode;					// 0 --> okay
    u8  OperatingRadius;			// current operation radius around the Home Position in m
	s16 TopSpeed;					// velocity in vertical direction in cm/s
	u8 TargetHoldTime;				// time in s to stay at the given target, counts down to 0 if target has been reached
	u8  Reserve[4];					// for future use
} __attribute__((packed)) NaviData_t;

/*
 * MikroKopter Flags
 * portions taken and adapted from
 * http://svn.mikrokopter.de/mikrowebsvn/filedetails.php?repname=FlightCtrl&path=%2Ftags%2FV0.72p%2Fuart.h
 */
#define NC_FLAG_FREE                    1
#define NC_FLAG_PH                      2
#define NC_FLAG_CH                      4
#define NC_FLAG_RANGE_LIMIT             8
#define NC_SERIAL_LINK_OK               16
#define NC_FLAG_TARGET_REACHED          32

#define FLAG_MOTOR_RUN  1
#define FLAG_FLY        2
#define FLAG_CALIBRATE  4
#define FLAG_START      8
