/****************************************************************************
 *   Copyright (C) 2009 by Claas Anders "CaScAdE" Rathje                    *
 *   admiralcascade@gmail.com                                               *
 *   Project-URL: http://www.mylifesucks.de/oss/c-osd/                      *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License.         *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program; if not, write to the                          *
 *   Free Software Foundation, Inc.,                                        *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 ****************************************************************************/

/* ##########################################################################
 * Software SPI to communicate with MAX7456
 * ##########################################################################*/
#define MAX_CS_HIGH             PORTA |=  (1 << PA1);
#define MAX_CS_LOW              PORTA &= ~(1 << PA1);
#define MAX_SDIN_HIGH           PORTA |=  (1 << PA2);
#define MAX_SDIN_LOW            PORTA &= ~(1 << PA2);
#define MAX_SCLK_HIGH           PORTA |=  (1 << PA3);
#define MAX_SCLK_LOW            PORTA &= ~(1 << PA3);
#define MAX_RESET_HIGH          PORTA |=  (1 << PA5);
#define MAX_RESET_LOW           PORTA &= ~(1 << PA5);


/* ##########################################################################
 * MAX7456 SPI & Display stuff
 * ##########################################################################*/

/**
 * Send a byte through SPI
 */
void spi_send(uint8_t);

/**
 *  Send <byte> to <address> of MAX7456
 */
void spi_send_byte(uint8_t, uint8_t);

/**
 *  write a <character> to <address> of MAX7456 display memory
 */
void write_char(uint16_t, char);

/**
 *  write a character <attribute> to <address> of MAX7456 display memory
 */
void write_char_att(uint16_t, char);
/**
 *  write a <character> at <x>/<y> to MAX7456 display memory
 */
void write_char_xy(uint8_t, uint8_t, char);
/**
 *  write a  character <attribute> at <x>/<y> to MAX7456 display memory
 */
void write_char_att_xy(uint8_t, uint8_t, char attribute);

/**
 *  clear display by writing blank characters all over it
 */
void clear(void);

/**
 *  write an ascii <character> to <address> of MAX7456 display memory
 */
void write_ascii_char(uint16_t, char);

/**
 *  write an ascii <string> at <x>/<y> to MAX7456 display memory
 */
void write_ascii_string(uint8_t, uint8_t, char*);

/**
 *  write an ascii <string> from progmen at <x>/<y> to MAX7456 display memory
 */
void write_ascii_string_pgm(uint8_t, uint8_t, char*);

/**
 * Write only some digits of a unsigned <number> at <x>/<y> to MAX7456 display memory
 * <num> represents the largest multiple of 10 that will still be displayable as
 * the first digit, so num = 10 will be 0-99 and so on
 * <pad> = 1 will cause blank spaced to be filled up with zeros e.g. 007 instead of   7
 */
void write_ndigit_number_u(uint8_t, uint8_t, uint16_t, int16_t, uint8_t);

/**
 * Write only some digits of a signed <number> at <x>/<y> to MAX7456 display memory
 * <num> represents the largest multiple of 10 that will still be displayable as
 * the first digit, so num = 10 will be 0-99 and so on
 * <pad> = 1 will cause blank spaced to be filled up with zeros e.g. 007 instead of   7
 */
void write_ndigit_number_s(uint8_t, uint8_t, int16_t, int16_t, uint8_t);

/**
 * Write only some digits of a unsigned <number> at <x>/<y> to MAX7456 display memory
 * as /10th of the value
 * <num> represents the largest multiple of 10 that will still be displayable as
 * the first digit, so num = 10 will be 0-99 and so on
 * <pad> = 1 will cause blank spaced to be filled up with zeros e.g. 00.7 instead of   .7
 */
void write_ndigit_number_u_10th(uint8_t, uint8_t, uint16_t, int16_t, uint8_t);

/**
 * Write only some digits of a signed <number> at <x>/<y> to MAX7456 display memory
 * as /10th of the value
 * <num> represents the largest multiple of 10 that will still be displayable as
 * the first digit, so num = 10 will be 0-99 and so on
 * <pad> = 1 will cause blank spaced to be filled up with zeros e.g. 00.7 instead of   .7
 */
void write_ndigit_number_s_10th(uint8_t, uint8_t, int16_t, int16_t, uint8_t);

/**
 *  write <seconds> as human readable time at <x>/<y> to MAX7456 display mem
 */
void write_time(uint8_t, uint8_t, uint16_t);

/**
 * for testing write all chars to screen
 */
void write_all_chars();

/**
 * let the MAX7456 learn a new character at <number>
 * with <data>.
 */
void learn_char(uint8_t, unsigned char*);
