/****************************************************************************
 *   Copyright (C) 2009 by Claas Anders "CaScAdE" Rathje                    *
 *   admiralcascade@gmail.com                                               *
 *   Project-URL: http://www.mylifesucks.de/oss/c-osd/                      *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License.         *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program; if not, write to the                          *
 *   Free Software Foundation, Inc.,                                        *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 ****************************************************************************/

/* ##########################################################################
 * Debugging and general purpose definitions
 * ##########################################################################*/
#define ALLCHARSDEBUG 0		// set to 1 and flash firmware to see all chars

#ifndef WRITECHARS			// if WRITECHARS not set via makefile
#define WRITECHARS -1		// set to 2XX and flash firmware to write new char
							// enables the allchars as well to see results
#endif

#ifndef NTSC				// if NTSC is not thet via makefile
#define NTSC 0				// set to 1 for NTSC mode + lifts the bottom line
#endif

#define HUD 1				// set to 0 to disable HUD by default
#define ARTHORIZON 0		// set to 1 to enable roll&nick artificial horizon by default
#define STATS 1				// set to 1 to enable statistics during motor off by default
#define WARNINGS 1			// set to 1 to display battery+rc warning even if HUD is disabled

#define UBAT_WRN 94			// voltage for blinking warning, like FC settings
#define RCLVL_WRN 100		// make the RC level blink if below this number

// ### read datasheet before changing stuff below this line :)
#define BLINK	0b01001111	// attribute byte for blinking chars

/* ##########################################################################
 * FLAGS usable during runtime
 * ##########################################################################*/
#define COSD_FLAG_NTSC			 1
#define COSD_FLAG_HUD			 2
#define COSD_FLAG_ARTHORIZON	 4
#define COSD_FLAG_STATS			 8
#define COSD_FLAG_WARNINGS		16
#define COSD_ICONS_WRITTEN		32

/* ##########################################################################
 * LED controll
 * ##########################################################################*/
#define LED1_ON			PORTC |=  (1 << PC0);
#define LED1_OFF		PORTC &= ~(1 << PC0);
#define LED2_ON			PORTC |=  (1 << PC1);
#define LED2_OFF		PORTC &= ~(1 << PC1);
#define LED3_ON			PORTC |=  (1 << PC2);
#define LED3_OFF		PORTC &= ~(1 << PC2);
#define LED4_ON			PORTC |=  (1 << PC3);
#define LED4_OFF		PORTC &= ~(1 << PC3);

/* ##########################################################################
 * switch controll
 * ##########################################################################*/
#define S1_PRESSED		!(PINC & (1<<PC5))
#define S2_PRESSED		!(PINC & (1<<PC4))

