/****************************************************************************
 *   Copyright (C) 2009 by Claas Anders "CaScAdE" Rathje                    *
 *   admiralcascade@gmail.com                                               *
 *   Project-URL: http://www.mylifesucks.de/oss/c-osd/                      *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License.         *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program; if not, write to the                          *
 *   Free Software Foundation, Inc.,                                        *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 ****************************************************************************/

/**
 * easy char creation:
 * http://cascade.dyndns.org/~cascade/scripts/max7456/
 */
// flashing more than 8 chars per time is not proven to be safe
// so take care

#if WRITECHARS == 200
// GPS
unsigned char cc8[54] = {0x55, 0x50, 0x55, 0x55, 0x4a, 0x15, 0x55, 0x2a,
    0x85, 0x55, 0x2a, 0xa1, 0x55, 0x4a, 0xa8, 0x55,
    0x52, 0xa8, 0x55, 0x54, 0xaa, 0x55, 0x55, 0x09,
    0x55, 0x55, 0x52, 0x55, 0x55, 0x1a, 0x55, 0x51,
    0x96, 0x55, 0x18, 0x85, 0x54, 0x88, 0x28, 0x54,
    0x82, 0x05, 0x55, 0x20, 0xa1, 0x55, 0x48, 0x15,
    0x55, 0x52, 0x85, 0x55, 0x54, 0x15};

unsigned char cc9[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45,
    0x55, 0x55, 0x21, 0x55, 0x55, 0xa8, 0x55, 0x55,
    0xa1, 0x55, 0x55, 0x98, 0x15, 0x55, 0x2a, 0x85,
    0x55, 0x4a, 0xa1, 0x55, 0x4a, 0xa8, 0x55, 0x52,
    0xaa, 0x15, 0x54, 0xaa, 0x15, 0x55, 0x28, 0x55,
    0x55, 0x41, 0x55, 0x55, 0x55, 0x55};

// RC
unsigned char cca[54] = {0x54, 0xaa, 0x85, 0x52, 0x00, 0x21, 0x48, 0x2a,
    0x08, 0x60, 0x80, 0x82, 0x62, 0x08, 0x22, 0x62,
    0x2a, 0x22, 0x62, 0x08, 0x22, 0x60, 0x88, 0x82,
    0x48, 0x08, 0x08, 0x52, 0x08, 0x21, 0x54, 0x48,
    0x45, 0x55, 0x48, 0x55, 0x55, 0x48, 0x55, 0x55,
    0x48, 0x55, 0x55, 0x48, 0x55, 0x55, 0x48, 0x55,
    0x55, 0x2a, 0x15, 0x54, 0xaa, 0x85};

// km/h
unsigned char ccb[54] = {0x55, 0x55, 0x55, 0x01, 0x55, 0x55, 0x21, 0x55,
    0x55, 0x20, 0x15, 0x55, 0x22, 0x15, 0x55, 0x28,
    0x15, 0x55, 0x22, 0x15, 0x55, 0x00, 0x00, 0x15,
    0x52, 0xaa, 0x15, 0x52, 0x22, 0x15, 0x52, 0x22,
    0x15, 0x50, 0x00, 0x05, 0x55, 0x54, 0x85, 0x55,
    0x54, 0x80, 0x55, 0x54, 0xa8, 0x55, 0x54, 0x88,
    0x55, 0x54, 0x88, 0x55, 0x54, 0x00};


// small meters m
unsigned char ccc[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x15, 0x22,
    0x8a, 0x15, 0x28, 0xa2, 0x15, 0x20, 0x82, 0x15,
    0x20, 0x82, 0x15, 0x00, 0x00, 0x15};

// vario down
unsigned char ccd[54] = {0x55, 0x00, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28,
    0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55,
    0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55,
    0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28,
    0x55, 0x00, 0x28, 0x00, 0x2a, 0xaa, 0xa8, 0x0a,
    0xaa, 0xa0, 0x42, 0xaa, 0x81, 0x50, 0xaa, 0x05,
    0x54, 0x28, 0x15, 0x55, 0x00, 0x55};

// vario hold
unsigned char cce[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// vario up
unsigned char ccf[54] = {0x55, 0x00, 0x55, 0x54, 0x28, 0x15, 0x50, 0xaa,
    0x05, 0x42, 0xaa, 0x81, 0x0a, 0xaa, 0xa0, 0x2a,
    0xaa, 0xa8, 0x00, 0x28, 0x00, 0x55, 0x28, 0x55,
    0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28,
    0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55,
    0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55,
    0x55, 0x28, 0x55, 0x55, 0x00, 0x55};

learn_char(200, cc8);
learn_char(201, cc9);
learn_char(202, cca);
learn_char(203, ccb);
learn_char(204, ccc);
learn_char(205, ccd);
learn_char(206, cce);
learn_char(207, ccf);
#endif

#if WRITECHARS == 208
// degree symbol
unsigned char cd0[54] = {0x55, 0x55, 0x55, 0x54, 0x01, 0x55, 0x52, 0xa8,
    0x55, 0x48, 0x02, 0x15, 0x48, 0x52, 0x15, 0x48,
    0x52, 0x15, 0x48, 0x02, 0x15, 0x52, 0xa8, 0x55,
    0x54, 0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// clock on symbol
unsigned char cd1[54] = {0x54, 0x14, 0x51, 0x52, 0x82, 0x08, 0x48, 0x22,
    0x88, 0x48, 0x22, 0x28, 0x48, 0x22, 0x28, 0x52,
    0x82, 0x08, 0x54, 0x14, 0x51, 0x55, 0x40, 0x55,
    0x55, 0x2a, 0x15, 0x54, 0x88, 0x85, 0x52, 0x08,
    0x21, 0x48, 0x48, 0x08, 0x48, 0x4a, 0x88, 0x48,
    0x50, 0x08, 0x52, 0x15, 0x21, 0x54, 0x80, 0x85,
    0x55, 0x2a, 0x15, 0x55, 0x40, 0x55};

// clock fly symbol
unsigned char cd2[54] = {0x40, 0x45, 0x11, 0x2a, 0x20, 0x88, 0x20, 0x20,
    0x88, 0x28, 0x21, 0x21, 0x21, 0x20, 0x21, 0x21,
    0x2a, 0x21, 0x45, 0x40, 0x45, 0x55, 0x40, 0x55,
    0x55, 0x2a, 0x15, 0x54, 0x88, 0x85, 0x52, 0x08,
    0x21, 0x48, 0x48, 0x08, 0x48, 0x4a, 0x88, 0x48,
    0x50, 0x08, 0x52, 0x15, 0x21, 0x54, 0x80, 0x85,
    0x55, 0x2a, 0x15, 0x55, 0x40, 0x55};

// compass north
unsigned char cd3[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54,
    0x54, 0x55, 0x52, 0x12, 0x15, 0x52, 0x82, 0x15,
    0x02, 0x82, 0x00, 0xa2, 0x22, 0x2a, 0x02, 0x0a,
    0x00, 0x52, 0x0a, 0x15, 0x52, 0x12, 0x15, 0x54,
    0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// compass south
unsigned char cd4[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x01, 0x55, 0x54, 0xa8, 0x55, 0x52, 0x02, 0x15,
    0x04, 0x84, 0x40, 0xa1, 0x21, 0x2a, 0x04, 0x48,
    0x40, 0x52, 0x02, 0x15, 0x54, 0xa8, 0x55, 0x55,
    0x01, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// compass east
unsigned char cd5[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54,
    0x00, 0x55, 0x52, 0xaa, 0x15, 0x52, 0x00, 0x55,
    0x02, 0x05, 0x40, 0xa2, 0xa1, 0x2a, 0x02, 0x05,
    0x40, 0x52, 0x00, 0x55, 0x52, 0xaa, 0x15, 0x54,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// compass west
unsigned char cd6[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54,
    0x54, 0x55, 0x52, 0x12, 0x15, 0x52, 0x12, 0x15,
    0x02, 0x02, 0x00, 0xa2, 0x22, 0x2a, 0x02, 0x8a,
    0x00, 0x52, 0x8a, 0x15, 0x52, 0x12, 0x15, 0x54,
    0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// compass between
unsigned char cd7[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x45, 0x55, 0x55, 0x21, 0x55,
    0x01, 0x21, 0x00, 0xa8, 0x20, 0xaa, 0x01, 0x21,
    0x00, 0x55, 0x21, 0x55, 0x55, 0x45, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

learn_char(208, cd0);
learn_char(209, cd1);
learn_char(210, cd2);
learn_char(211, cd3);
learn_char(212, cd4);
learn_char(213, cd5);
learn_char(214, cd6);
learn_char(215, cd7);
#endif

#if WRITECHARS == 216
// compass line
unsigned char cd8[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow right
unsigned char cd9[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x15, 0x55, 0x54, 0x85, 0x40, 0x00, 0xa1,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x40, 0x00,
    0xa1, 0x55, 0x54, 0x85, 0x55, 0x55, 0x15, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow right-up
unsigned char cda[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x40, 0x01, 0x55, 0x2a, 0xa8, 0x55,
    0x4a, 0xa8, 0x55, 0x52, 0xa8, 0x55, 0x4a, 0xa8,
    0x55, 0x2a, 0x28, 0x54, 0xa8, 0x48, 0x52, 0xa1,
    0x51, 0x4a, 0x85, 0x55, 0x52, 0x15, 0x55, 0x54,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow up
unsigned char cdb[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x41, 0x55, 0x55, 0x28, 0x55, 0x54,
    0xaa, 0x15, 0x52, 0xaa, 0x85, 0x54, 0x28, 0x15,
    0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28,
    0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x55,
    0x28, 0x55, 0x55, 0x41, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow left-up
unsigned char cdc[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x40, 0x01, 0x55, 0x2a, 0xa8, 0x55, 0x2a,
    0xa1, 0x55, 0x2a, 0x85, 0x55, 0x2a, 0xa1, 0x55,
    0x28, 0xa8, 0x55, 0x21, 0x2a, 0x15, 0x45, 0x4a,
    0x85, 0x55, 0x52, 0xa1, 0x55, 0x54, 0x85, 0x55,
    0x55, 0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow left
unsigned char cdd[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54,
    0x55, 0x55, 0x52, 0x15, 0x55, 0x4a, 0x00, 0x01,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x4a, 0x00,
    0x01, 0x52, 0x15, 0x55, 0x54, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow left-down
unsigned char cde[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x15, 0x55,
    0x54, 0x85, 0x55, 0x52, 0xa1, 0x45, 0x4a, 0x85,
    0x21, 0x2a, 0x15, 0x28, 0xa8, 0x55, 0x2a, 0xa1,
    0x55, 0x2a, 0x85, 0x55, 0x2a, 0xa1, 0x55, 0x2a,
    0xa8, 0x55, 0x40, 0x01, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// arrow down
unsigned char cdf[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x41, 0x55, 0x55, 0x28, 0x55, 0x55,
    0x28, 0x55, 0x55, 0x28, 0x55, 0x55, 0x28, 0x55,
    0x55, 0x28, 0x55, 0x55, 0x28, 0x55, 0x54, 0x28,
    0x15, 0x52, 0xaa, 0x85, 0x54, 0xaa, 0x15, 0x55,
    0x28, 0x55, 0x55, 0x41, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

learn_char(216, cd8);
learn_char(217, cd9);
learn_char(218, cda);
learn_char(219, cdb);
learn_char(220, cdc);
learn_char(221, cdd);
learn_char(222, cde);
learn_char(223, cdf);
#endif

#if WRITECHARS == 224
// arrow right-down
unsigned char ce0[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x54, 0x55, 0x55, 0x52,
    0x15, 0x55, 0x4a, 0x85, 0x55, 0x52, 0xa1, 0x51,
    0x54, 0xa8, 0x48, 0x55, 0x2a, 0x28, 0x55, 0x4a,
    0xa8, 0x55, 0x52, 0xa8, 0x55, 0x4a, 0xa8, 0x55,
    0x2a, 0xa8, 0x55, 0x40, 0x01, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// horizon up
unsigned char ce1[54] = {0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// horizon middle
unsigned char ce2[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// horizon down
unsigned char ce3[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00,
    0x00, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0x00, 0x00, 0x00, 0x55, 0x55, 0x55};

// horizon center
unsigned char ce4[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00,
    0x14, 0x00, 0xaa, 0x14, 0xaa, 0xaa, 0x82, 0xaa,
    0x00, 0xaa, 0x00, 0x54, 0x00, 0x15};

// horizon roll
unsigned char ce5[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x00, 0x55, 0x00, 0x2a, 0x14, 0xa8, 0x4a,
    0x82, 0xa1, 0x52, 0xaa, 0x85, 0x54, 0xaa, 0x15,
    0x55, 0x28, 0x55, 0x55, 0x41, 0x55};

// gps PH
unsigned char ce6[54] = {0x55, 0x05, 0x11, 0x54, 0xa0, 0x88, 0x54, 0x88,
    0x88, 0x54, 0xa0, 0xa8, 0x54, 0x84, 0x88, 0x44,
    0x84, 0x88, 0x21, 0x15, 0x11, 0xa8, 0x55, 0x55,
    0xa1, 0x55, 0x55, 0x98, 0x15, 0x55, 0x2a, 0x85,
    0x55, 0x4a, 0xa1, 0x55, 0x4a, 0xa8, 0x55, 0x52,
    0xaa, 0x15, 0x54, 0xaa, 0x15, 0x55, 0x28, 0x55,
    0x55, 0x41, 0x55, 0x55, 0x55, 0x55};

// gps CH
unsigned char ce7[54] = {0x55, 0x55, 0x41, 0x55, 0x55, 0x28, 0x55, 0x54,
    0x81, 0x55, 0x54, 0x85, 0x55, 0x54, 0x81, 0x45,
    0x55, 0x28, 0x21, 0x55, 0x01, 0xa8, 0x54, 0x88,
    0xa1, 0x54, 0x88, 0x98, 0x14, 0xa8, 0x2a, 0x84,
    0x88, 0x4a, 0xa0, 0x88, 0x4a, 0xa8, 0x11, 0x52,
    0xaa, 0x15, 0x54, 0xaa, 0x15, 0x55, 0x28, 0x55,
    0x55, 0x41, 0x55, 0x55, 0x55, 0x55};

learn_char(224, ce0);
learn_char(225, ce1);
learn_char(226, ce2);
learn_char(227, ce3);
learn_char(228, ce4);
learn_char(229, ce5);
learn_char(230, ce6);
learn_char(231, ce7);
#endif

#if WRITECHARS == 232
// small arrow down
unsigned char ce8[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x0a, 0xaa,
    0xa0, 0x52, 0xaa, 0x85, 0x54, 0xaa, 0x15, 0x55,
    0x28, 0x55, 0x55, 0x41, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// big arrow down
unsigned char ce9[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x00, 0x28,
    0x00, 0x55, 0x28, 0x55, 0x40, 0x28, 0x01, 0x2a,
    0xaa, 0xa8, 0x4a, 0xaa, 0xa1, 0x52, 0xaa, 0x85,
    0x54, 0xaa, 0x15, 0x55, 0x28, 0x55};

// small arrow up
unsigned char cea[54] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x41, 0x55, 0x55, 0x28, 0x55, 0x54,
    0xaa, 0x15, 0x52, 0xaa, 0x85, 0x0a, 0xaa, 0xa0,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

// big arrow up
unsigned char ceb[54] = {0x55, 0x28, 0x55, 0x54, 0xaa, 0x15, 0x52, 0xaa,
    0x85, 0x4a, 0xaa, 0xa1, 0x2a, 0xaa, 0xa8, 0x40,
    0x28, 0x01, 0x55, 0x28, 0x55, 0x00, 0x28, 0x00,
    0x2a, 0xaa, 0xa8, 0x2a, 0xaa, 0xa8, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55};

learn_char(232, ce8);
learn_char(233, ce9);
learn_char(234, cea);
learn_char(235, ceb);
#endif

