/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.testing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransparencyTest
extends JWindow
implements ChangeListener {
    private JSlider slider = new JSlider(0, 255);

    public TransparencyTest() {
        this.slider.setValue(255);
        this.slider.addChangeListener(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.slider, "Center");
        this.setContentPane(panel);
        this.setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(null);
    }

    public void stateChanged(ChangeEvent e) {
        double value = (double)this.slider.getValue() / (double)this.slider.getMaximum();
        this.setWindowOpacity(this, value);
    }

    public void setWindowOpacity(JWindow frame, double opacity) {
        long value = (int)(255.0 * opacity) << 24;
        try {
            Field peerField = Component.class.getDeclaredField("peer");
            peerField.setAccessible(true);
            Class<?> xWindowPeerClass = Class.forName("sun.awt.X11.XWindowPeer");
            Method getWindowMethod = xWindowPeerClass.getMethod("getWindow", new Class[0]);
            long windowId = (Long)getWindowMethod.invoke(peerField.get(frame), new Object[0]);
            Class<?> xAtomClass = Class.forName("sun.awt.X11.XAtom");
            Method getMethod = xAtomClass.getMethod("get", String.class);
            Method setCard32PropertyMethod = xAtomClass.getMethod("setCard32Property", Long.TYPE, Long.TYPE);
            setCard32PropertyMethod.invoke(getMethod.invoke(null, "_NET_WM_WINDOW_OPACITY"), windowId, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        new TransparencyTest().setVisible(true);
    }
}

