/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.protocol;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.gui.LogPanel;
import de.mylifesucks.oss.ncsimulator.protocol.CommunicationBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpComm
extends CommunicationBase
implements Runnable {
    ServerSocket serverSocket;
    Thread readThread;

    public TcpComm(int listenPort) throws Exception {
        System.out.println("Create socket for listening on port:" + listenPort);
        this.serverSocket = new ServerSocket(listenPort);
        System.out.println("Listening for connections on port " + this.serverSocket.getLocalPort());
        this.readThread = new Thread(this);
        this.readThread.start();
    }

    public void run() {
        byte[] readBuffer = new byte[220];
        Socket clientSocket = null;
        try {
            while (true) {
                System.out.println("Wait for connection");
                clientSocket = this.serverSocket.accept();
                try {
                    System.out.println("Connection established with " + clientSocket);
                    InputThread input = new InputThread(clientSocket);
                    input.start();
                }
                catch (Exception ex) {
                    System.out.println("Socket error:" + ex);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Accept failed");
            System.exit(-1);
            System.out.println("Thread ended");
            return;
        }
    }

    class InputThread
    extends Thread {
        Socket clientSocket;

        public InputThread(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        public void run() {
            byte[] readBuffer = new byte[220];
            try {
                CommunicationBase.outputStream = this.clientSocket.getOutputStream();
                InputStream inputStream = this.clientSocket.getInputStream();
                while (!this.clientSocket.isClosed()) {
                    int foo;
                    int numBytes = inputStream.read(readBuffer);
                    if (numBytes < 0) {
                        this.clientSocket.close();
                    }
                    String out = "";
                    for (int i = 0; i < numBytes; ++i) {
                        out = out + (char)readBuffer[i];
                    }
                    if (!out.startsWith("#a") && !out.startsWith("#co")) {
                        System.out.println("Read bytes from socket:" + out);
                    }
                    for (foo = 0; foo < readBuffer.length - 5 && (readBuffer[foo] != 27 || readBuffer[foo + 1] != 27 || readBuffer[foo + 2] != 85 || readBuffer[foo + 4] != 0); ++foo) {
                    }
                    if (readBuffer[foo] == 27 && readBuffer[foo + 1] == 27 && readBuffer[foo + 3] != 170) {
                        if (LogPanel.showInput.isSelected()) {
                            LogPanel.giveMessage("back to NC debug", LogPanel.green);
                        }
                        DataStorage.setUART(DataStorage.UART_CONNECTION.NC);
                        TcpComm.this.UartState = '\u0000';
                        continue;
                    }
                    for (int i = 0; i < numBytes; ++i) {
                        TcpComm.this.USART0_RX_vect((char)readBuffer[i]);
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("Socket error:" + ex);
            }
        }
    }
}

