/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.protocol;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.gui.LogPanel;
import de.mylifesucks.oss.ncsimulator.protocol.CommunicationBase;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialComm
extends CommunicationBase
implements Runnable,
SerialPortEventListener {
    static CommPortIdentifier portId;
    static CommPortIdentifier saveportId;
    SerialPort serialPort;
    Thread readThread;
    boolean isUSB;
    static HashMap<String, CommPortIdentifier> portMap;
    byte[] readBuffer = new byte[220];

    public static HashMap<String, CommPortIdentifier> getPorts() {
        if (portMap == null) {
            portMap = new HashMap();
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1) continue;
                portMap.put(portId.getName(), portId);
            }
        }
        return portMap;
    }

    public void initwritetoport() {
        try {
            outputStream = this.serialPort.getOutputStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (!this.isUSB) {
                this.serialPort.notifyOnOutputEmpty(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error setting event notification");
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public SerialComm(String port, boolean isUSB) throws Exception {
        String defaultPort;
        this.isUSB = isUSB;
        boolean portFound = false;
        String osname = System.getProperty("os.name", "").toLowerCase();
        if (osname.startsWith("windows")) {
            defaultPort = "COM1";
        } else if (osname.startsWith("linux")) {
            defaultPort = "/dev/ttyS0";
        } else if (osname.startsWith("mac")) {
            defaultPort = "????";
        } else {
            System.out.println("Sorry, your operating system is not supported");
            return;
        }
        if (port != null) {
            defaultPort = port;
        }
        System.out.println("Set default port to " + defaultPort);
        if (!portMap.keySet().contains(defaultPort)) {
            System.out.println("port " + defaultPort + " not found.");
            System.exit(0);
        }
        portId = portMap.get(defaultPort);
        this.serialPort = (SerialPort)portId.open("SimpleReadApp", 2000);
        this.inputStream = this.serialPort.getInputStream();
        this.serialPort.addEventListener(this);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.setSerialPortParams(57600, 8, 1, 0);
        this.initwritetoport();
        this.readThread = new Thread(this);
        this.readThread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        int foo;
                        int numBytes = this.inputStream.read(this.readBuffer);
                        for (foo = 0; foo < this.readBuffer.length - 5 && (this.readBuffer[foo] != 27 || this.readBuffer[foo + 1] != 27 || this.readBuffer[foo + 2] != 85 || this.readBuffer[foo + 4] != 0); ++foo) {
                        }
                        if (this.readBuffer[foo] == 27 && this.readBuffer[foo + 1] == 27 && this.readBuffer[foo + 3] != 170) {
                            if (LogPanel.showInput.isSelected()) {
                                LogPanel.giveMessage("back to NC debug", LogPanel.green);
                            }
                            DataStorage.setUART(DataStorage.UART_CONNECTION.NC);
                            this.UartState = '\u0000';
                            continue;
                        }
                        for (int i = 0; i < numBytes; ++i) {
                            this.USART0_RX_vect((char)this.readBuffer[i]);
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

