/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.protocol;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.gui.LogPanel;
import java.io.OutputStream;

public class Encode {
    public OutputStream writer;

    public Encode(OutputStream writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream writer) {
        this.writer = writer;
    }

    public static int[] Decode64(byte[] in_arr, int len) {
        return Encode.Decode64(in_arr, 0, len);
    }

    public static int[] Decode64(byte[] in_arr, int offset, int len) {
        int ptrIn = offset;
        int ptr = 0;
        int[] out_arr = new int[len];
        while (len != 0) {
            int a = 0;
            int b = 0;
            int c = 0;
            int d = 0;
            try {
                a = in_arr[ptrIn++] - 61;
                b = in_arr[ptrIn++] - 61;
                c = in_arr[ptrIn++] - 61;
                d = in_arr[ptrIn++] - 61;
            }
            catch (Exception e) {
                // empty catch block
            }
            int x = a << 2 | b >> 4;
            int y = (b & 0xF) << 4 | c >> 2;
            int z = (c & 3) << 6 | d;
            if (len-- == 0) break;
            out_arr[ptr++] = x;
            if (len-- == 0) break;
            out_arr[ptr++] = y;
            if (len-- == 0) break;
            out_arr[ptr++] = z;
        }
        return out_arr;
    }

    public synchronized void send_command_nocheck(byte modul, char cmd, int[] params) {
        DataStorage.statusBar.uartTX.toggle();
        this.writer = DataStorage.serial == null ? System.out : DataStorage.serial.getOutputStream();
        if (this.writer != null) {
            byte[] send_buff = new byte[3 + (params.length / 3 + (params.length % 3 == 0 ? 0 : 1)) * 4];
            send_buff[0] = 35;
            send_buff[1] = (byte)(modul + 97);
            send_buff[2] = (byte)cmd;
            for (int param_pos = 0; param_pos < params.length / 3 + (params.length % 3 == 0 ? 0 : 1); ++param_pos) {
                int a = param_pos * 3 < params.length ? params[param_pos * 3] : 0;
                int b = param_pos * 3 + 1 < params.length ? params[param_pos * 3 + 1] : 0;
                int c = param_pos * 3 + 2 < params.length ? params[param_pos * 3 + 2] : 0;
                send_buff[3 + param_pos * 4] = (byte)((a >> 2) + 61);
                send_buff[3 + param_pos * 4 + 1] = (byte)(61 + ((a & 3) << 4 | (b & 0xF0) >> 4));
                send_buff[3 + param_pos * 4 + 2] = (byte)(61 + ((b & 0xF) << 2 | (c & 0xC0) >> 6));
                send_buff[3 + param_pos * 4 + 3] = (byte)(61 + (c & 0x3F));
            }
            try {
                int tmp_crc = 0;
                for (int tmp_i = 0; tmp_i < send_buff.length; ++tmp_i) {
                    tmp_crc += send_buff[tmp_i];
                }
                this.writer.write(send_buff, 0, send_buff.length);
                this.writer.write((char)((tmp_crc %= 4096) / 64 + 61));
                this.writer.write((char)(tmp_crc % 64 + 61));
                this.writer.write(13);
                this.writer.flush();
                String out = "";
                for (byte i : send_buff) {
                    out = out + (char)i;
                }
                out = out + (char)(tmp_crc / 64 + 61);
                out = out + (char)(tmp_crc % 64 + 61);
                out = out + '\r';
                if (LogPanel.showOutput.isSelected()) {
                    LogPanel.giveMessage(out, LogPanel.red);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void send_command(int modul, char cmd, int[] params) {
        this.send_command_nocheck((byte)modul, cmd, params);
    }

    public void send_command(int modul, char cmd) {
        this.send_command(modul, cmd, new int[0]);
    }

    public static boolean mkCRC(byte[] buffer) {
        int end;
        int buf_ptr;
        for (buf_ptr = 0; buffer[buf_ptr] != 35 && buf_ptr < buffer.length; ++buf_ptr) {
        }
        for (end = buf_ptr; buffer[end] != 13 && end < buffer.length; ++end) {
        }
        return Encode.mkCRC(buffer, buf_ptr, end);
    }

    public static boolean mkCRC(byte[] buffer, int buf_ptr, int end) {
        int crc = 0;
        for (int i = buf_ptr; i < end - 2; ++i) {
            crc += buffer[i];
        }
        int crc1 = 61 + (crc %= 4096) / 64;
        int crc2 = 61 + crc % 64;
        return crc1 == buffer[end - 2] && crc2 == buffer[end - 1];
    }
}

