/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.protocol;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.datatypes.Waypoint_t;
import de.mylifesucks.oss.ncsimulator.datatypes.c_int;
import de.mylifesucks.oss.ncsimulator.datatypes.s8;
import de.mylifesucks.oss.ncsimulator.gui.LogPanel;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public class CommunicationBase {
    public static final int ANY_ADDRESS = 0;
    public static final int FC_ADDRESS = 1;
    public static final int NC_ADDRESS = 2;
    public static final int MK3MAG_ADDRESS = 3;
    public static final int MKOSD_ADDRESS = 4;
    public static final int BL_ADDRESS = 5;
    InputStream inputStream;
    static OutputStream outputStream;
    public static final int MAX_EMPFANGS_BUFF = 190;
    volatile int[] RxdBuffer = new int[190];
    int crc;
    int crc1;
    int crc2;
    int buf_ptr;
    char UartState = '\u0000';
    boolean CrcOkay = false;
    volatile boolean NeuerDatensatzEmpfangen = false;
    int AnzahlEmpfangsBytes = 0;
    int RxDataLen = 0;
    int pRxData = 0;

    public OutputStream getOutputStream() {
        return outputStream;
    }

    protected void USART0_RX_vect(int SioTmp) {
        if (this.buf_ptr >= 190) {
            this.UartState = '\u0000';
        }
        if (SioTmp == 13 && this.UartState == '\u0002') {
            this.UartState = '\u0000';
            this.crc -= this.RxdBuffer[this.buf_ptr - 2];
            this.crc -= this.RxdBuffer[this.buf_ptr - 1];
            this.crc %= 4096;
            this.crc1 = 61 + this.crc / 64;
            this.crc2 = 61 + this.crc % 64;
            this.CrcOkay = false;
            this.CrcOkay = this.crc1 == this.RxdBuffer[this.buf_ptr - 2] && this.crc2 == this.RxdBuffer[this.buf_ptr - 1];
            if (!this.NeuerDatensatzEmpfangen && this.CrcOkay) {
                this.NeuerDatensatzEmpfangen = true;
                this.AnzahlEmpfangsBytes = this.buf_ptr + 1;
                this.RxdBuffer[this.buf_ptr] = 13;
                final int[] RxdBuffer_work = new int[190];
                System.arraycopy(this.RxdBuffer, 0, RxdBuffer_work, 0, this.RxdBuffer.length);
                DataStorage.executors.submit(new Runnable(){

                    public void run() {
                        CommunicationBase.this.BearbeiteRxDaten(RxdBuffer_work);
                    }
                });
            }
        } else {
            switch (this.UartState) {
                case '\u0000': {
                    if (SioTmp == 35 && !this.NeuerDatensatzEmpfangen) {
                        this.UartState = '\u0001';
                    }
                    this.buf_ptr = 0;
                    this.RxdBuffer[this.buf_ptr++] = SioTmp;
                    this.crc = SioTmp;
                    break;
                }
                case '\u0001': {
                    this.UartState = (char)(this.UartState + '\u0001');
                    this.RxdBuffer[this.buf_ptr++] = SioTmp;
                    this.crc += SioTmp;
                    break;
                }
                case '\u0002': {
                    this.RxdBuffer[this.buf_ptr] = SioTmp;
                    if (this.buf_ptr < 190) {
                        ++this.buf_ptr;
                    } else {
                        this.UartState = '\u0000';
                    }
                    this.crc += SioTmp;
                    break;
                }
                default: {
                    this.UartState = '\u0000';
                }
            }
        }
    }

    public void Decode64(int[] RxdBuffer) {
        int ptrIn = 3;
        int ptrOut = 3;
        int len = this.AnzahlEmpfangsBytes - 6;
        while (len != 0) {
            int a = 0;
            int b = 0;
            int c = 0;
            int d = 0;
            try {
                a = RxdBuffer[ptrIn++] - 61;
                b = RxdBuffer[ptrIn++] - 61;
                c = RxdBuffer[ptrIn++] - 61;
                d = RxdBuffer[ptrIn++] - 61;
            }
            catch (Exception e) {
                // empty catch block
            }
            int x = a << 2 | b >> 4;
            int y = (b & 0xF) << 4 | c >> 2;
            int z = (c & 3) << 6 | d;
            if (len-- == 0) break;
            RxdBuffer[ptrOut++] = x;
            if (len-- == 0) break;
            RxdBuffer[ptrOut++] = y;
            if (len-- == 0) break;
            RxdBuffer[ptrOut++] = z;
        }
        this.pRxData = 3;
        this.RxDataLen = ptrOut - 3;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void BearbeiteRxDaten(int[] RxdBuffer) {
        block97: {
            if (!this.NeuerDatensatzEmpfangen) {
                return;
            }
            DataStorage.statusBar.uartRX.toggle();
            String out = "";
            for (int i = this.pRxData; i < this.AnzahlEmpfangsBytes; ++i) {
                out = out + (char)RxdBuffer[i];
            }
            if (LogPanel.showInput.isSelected()) {
                LogPanel.giveMessage(out, LogPanel.green);
            }
            this.Decode64(RxdBuffer);
            try {
                if (outputStream == null) break block97;
                int tempchar = 0;
                switch (DataStorage.UART) {
                    case NC: {
                        block7 : switch (RxdBuffer[1] - 97) {
                            case 2: {
                                block10 : switch (RxdBuffer[2]) {
                                    case 99: {
                                        DataStorage.data3d_t.requestTime = RxdBuffer[this.pRxData] * 10;
                                        if (DataStorage.data3d_t.requestTime <= 0L) break;
                                        DataStorage.encoder.send_command(2, 'C', DataStorage.data3d_t.getAsInt());
                                        break;
                                    }
                                    case 122: {
                                        break;
                                    }
                                    case 101: {
                                        break;
                                    }
                                    case 115: {
                                        System.out.println(DataStorage.UART.name() + ":" + (RxdBuffer[1] - 97) + (char)RxdBuffer[2] + " new target position");
                                        break;
                                    }
                                    case 116: {
                                        DataStorage.SystemTime.set(Calendar.getInstance());
                                        DataStorage.encoder.send_command(2, 'T', DataStorage.SystemTime.getAsInt());
                                        break;
                                    }
                                    case 117: {
                                        switch (RxdBuffer[this.pRxData]) {
                                            case 0: {
                                                DataStorage.setUART(DataStorage.UART_CONNECTION.FC);
                                                break block10;
                                            }
                                            case 1: {
                                                DataStorage.setUART(DataStorage.UART_CONNECTION.MK3MAG);
                                                break block10;
                                            }
                                            case 2: {
                                                DataStorage.setUART(DataStorage.UART_CONNECTION.MKGPS);
                                                break block7;
                                            }
                                        }
                                        break;
                                    }
                                    case 119: {
                                        Waypoint_t rec = new Waypoint_t("recieved WP");
                                        rec.loadFromInt(RxdBuffer, this.pRxData);
                                        System.out.println("recieved WP " + rec.Index.value);
                                        if (rec.Position.Status.value == 0L && rec.Index.value == 0L) {
                                            System.out.println("Clear WP");
                                            DataStorage.clearWP();
                                            DataStorage.encoder.send_command(2, 'W', new int[]{(int)rec.Index.value});
                                            break;
                                        }
                                        System.out.println("Set WP " + rec.Index.value);
                                        if (rec.Index.value > 32L) {
                                            System.out.println("Invalid index " + rec.Index.value);
                                            rec.Index.value = 254L;
                                        } else {
                                            DataStorage.waypointList[(int)(rec.Index.value - 1L)].loadFromInt(RxdBuffer, this.pRxData);
                                        }
                                        DataStorage.encoder.send_command(2, 'W', new int[]{(int)rec.Index.value});
                                        break;
                                    }
                                    case 120: {
                                        System.out.println(DataStorage.UART.name() + ":" + (RxdBuffer[1] - 97) + (char)RxdBuffer[2] + " Read Waypoint from List");
                                        int index = RxdBuffer[this.pRxData];
                                        System.out.println("Read index " + index);
                                        if (index <= DataStorage.waypointList.length) {
                                            DataStorage.encoder.send_command(2, 'X', c_int.concatArray(new int[]{DataStorage.waypointList.length, index}, DataStorage.waypointList[index - 1].getAsInt()));
                                            break;
                                        }
                                        DataStorage.encoder.send_command(2, 'X', new int[]{DataStorage.waypointList.length});
                                        break;
                                    }
                                    case 106: {
                                        break;
                                    }
                                    case 79: {
                                        DataStorage.naviData.loadFromInt(RxdBuffer, this.pRxData);
                                        DataStorage.coordVizualizer.update();
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                        switch (RxdBuffer[2]) {
                            case 97: {
                                int index = RxdBuffer[this.pRxData];
                                if (index > 31) {
                                    index = 31;
                                }
                                DataStorage.encoder.send_command(2, 'A', DataStorage.NCDebugOut.Analog[index].getLabelArray());
                                break;
                            }
                            case 100: {
                                DataStorage.NCDebugOut.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.NCDebugOut.requestTime > 0L) {
                                    DataStorage.encoder.send_command(2, 'D', DataStorage.NCDebugOut.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 99: {
                                DataStorage.str_Data3D.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.str_Data3D.requestTime > 0L) {
                                    DataStorage.encoder.send_command(2, 'C', DataStorage.str_Data3D.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 104: {
                                DataStorage.lcddata.requestTime = RxdBuffer[this.pRxData + 1] * 10;
                                if (DataStorage.lcddata.requestTime > 0L) {
                                    DataStorage.encoder.send_command(2, 'H', DataStorage.lcddata.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 107: {
                                int blNum = RxdBuffer[this.pRxData + 1];
                                blNum %= DataStorage.bldata_t.length;
                                DataStorage.bldata_t[0].requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.bldata_t[0].requestTime > 0L) {
                                    DataStorage.encoder.send_command(2, 'K', DataStorage.bldata_t[blNum].getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 108: {
                                DataStorage.encoder.send_command(2, 'L', DataStorage.lcddata.getAsInt());
                                break;
                            }
                            case 111: {
                                DataStorage.naviData.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.naviData.requestTime > 0L) {
                                    DataStorage.encoder.send_command(2, 'O', DataStorage.naviData.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 118: {
                                DataStorage.encoder.send_command(2, 'V', DataStorage.NCversion.getAsInt());
                                break;
                            }
                            case 68: {
                                DataStorage.FCDebugOut.loadFromInt(RxdBuffer, this.pRxData);
                                break block97;
                            }
                        }
                        break;
                    }
                    case FC: {
                        switch (RxdBuffer[1] - 97) {
                            case 1: {
                                switch (RxdBuffer[2]) {
                                    case 75: {
                                        break;
                                    }
                                    case 116: {
                                        break;
                                    }
                                    case 110: {
                                        DataStorage.encoder.send_command(1, 'N', DataStorage.mixerset.getAsInt());
                                        break;
                                    }
                                    case 109: {
                                        break;
                                    }
                                    case 112: {
                                        DataStorage.encoder.send_command(1, 'P', DataStorage.ppmarray.getAsInt());
                                        break;
                                    }
                                    case 113: {
                                        int para = RxdBuffer[this.pRxData];
                                        if (para == 255) {
                                            para = DataStorage.activeParamset;
                                        }
                                        if (para > 5) {
                                            para = 5;
                                        }
                                        DataStorage.encoder.send_command(1, 'Q', DataStorage.paramset[para - 1].getAsInt());
                                        break;
                                    }
                                    case 115: {
                                        if (1 <= RxdBuffer[this.pRxData] && RxdBuffer[this.pRxData] <= 5) {
                                            DataStorage.activeParamset = tempchar = RxdBuffer[this.pRxData];
                                            System.out.println("Set active setting to " + tempchar);
                                            DataStorage.paramset[tempchar - 1].loadFromInt(RxdBuffer, this.pRxData + 1);
                                        } else {
                                            tempchar = 0;
                                        }
                                        DataStorage.encoder.send_command(1, 'S', new int[]{tempchar});
                                        break;
                                    }
                                    case 102: {
                                        tempchar = RxdBuffer[this.pRxData];
                                        System.out.println("Set active setting to " + tempchar);
                                        DataStorage.encoder.send_command(1, 'F', new int[]{tempchar});
                                        break;
                                    }
                                    case 121: {
                                        s8 tempVal = new s8("temp");
                                        for (int i = 0; i < 12; ++i) {
                                            tempVal.loadFromInt(RxdBuffer, this.pRxData + i);
                                            DataStorage.ppmarray.PPMArray[13 + i].setValue(tempVal.value, false);
                                        }
                                        break;
                                    }
                                    case 117: {
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                        switch (RxdBuffer[2]) {
                            case 116: {
                                break;
                            }
                            case 75: {
                                break;
                            }
                            case 97: {
                                int index = RxdBuffer[this.pRxData];
                                if (index > 31) {
                                    index = 31;
                                }
                                DataStorage.encoder.send_command(1, 'A', DataStorage.FCDebugOut.Analog[index].getLabelArray());
                                break;
                            }
                            case 98: {
                                break;
                            }
                            case 99: {
                                DataStorage.str_Data3D.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.str_Data3D.requestTime > 0L) {
                                    DataStorage.encoder.send_command(1, 'C', DataStorage.str_Data3D.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 100: {
                                DataStorage.FCDebugOut.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.FCDebugOut.requestTime > 0L) {
                                    DataStorage.encoder.send_command(1, 'D', DataStorage.FCDebugOut.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 104: {
                                DataStorage.lcddata.requestTime = RxdBuffer[this.pRxData + 1] * 10;
                                if (DataStorage.lcddata.requestTime > 0L) {
                                    DataStorage.encoder.send_command(1, 'H', DataStorage.lcddata.getAsInt());
                                    break;
                                }
                                break block97;
                            }
                            case 108: {
                                break;
                            }
                            case 118: {
                                DataStorage.encoder.send_command(1, 'V', DataStorage.FCversion.getAsInt());
                                break;
                            }
                            case 103: {
                                break;
                            }
                        }
                        break;
                    }
                    case MK3MAG: {
                        switch (RxdBuffer[1] - 97) {
                            default: 
                        }
                        switch (RxdBuffer[2]) {
                            case 118: {
                                DataStorage.encoder.send_command(3, 'V', DataStorage.MK3version.getAsInt());
                                break;
                            }
                            case 97: {
                                int index = RxdBuffer[this.pRxData];
                                if (index > 31) {
                                    index = 31;
                                }
                                DataStorage.encoder.send_command(3, 'A', DataStorage.MK3MAGDebugOut.Analog[index].getLabelArray());
                                break;
                            }
                            case 100: {
                                DataStorage.MK3MAGDebugOut.requestTime = RxdBuffer[this.pRxData] * 10;
                                if (DataStorage.MK3MAGDebugOut.requestTime > 0L) {
                                    DataStorage.encoder.send_command(3, 'D', DataStorage.MK3MAGDebugOut.getAsInt());
                                }
                                break block97;
                            }
                        }
                        break;
                    }
                    case MKGPS: {
                        break;
                    }
                    default: {
                        System.out.println("Unknown Address : " + (char)RxdBuffer[2]);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Exception while getting the MK data");
                System.out.println(ex);
            }
        }
        this.NeuerDatensatzEmpfangen = false;
        this.pRxData = 0;
        this.RxDataLen = 0;
    }
}

