/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow.elements;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.datatypes.c_int;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class c_intElement {
    private String domain = "";
    public static final String DATADOMAIN = "Data Domain";
    private String valName = "";
    public static final String DATAVALNAME = "Data Value Name";
    private long offset = 0L;
    private JTextField offsetField;
    public static final String ADDOFFSET = "An Offset value to add before computing the value";
    private double scaleFactor = 1.0;
    private JTextField scaleField;
    public static final String SCALEFACTOR = "Scalefactor to multiply value with";
    public static final String CONSTALIAS = "<<< CONST0 >>>";
    private String myName;
    private Preferences locPref;
    private DefaultListModel listModel;
    private JList list;
    private JComponent myComponent;

    public c_intElement(Preferences locPref, String name) {
        this.myName = this.getClass().getSimpleName() + name;
        this.locPref = locPref;
        this.domain = locPref.get(this.myName + DATADOMAIN, this.domain);
        this.valName = locPref.get(this.myName + DATAVALNAME, this.valName);
        this.offset = locPref.getLong(this.myName + ADDOFFSET, this.offset);
        this.scaleFactor = locPref.getDouble(this.myName + SCALEFACTOR, this.scaleFactor);
        this.initMyComponent();
    }

    public String getMyname() {
        return this.myName;
    }

    public void persist(String name) {
        this.myName = this.getClass().getSimpleName() + name;
        try {
            this.offset = Long.valueOf(this.offsetField.getText());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            this.scaleFactor = Double.valueOf(this.scaleField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.list.getSelectedValue() != null) {
            this.valName = this.list.getSelectedValue().toString();
            this.locPref.put(this.myName + DATADOMAIN, this.domain);
            this.locPref.put(this.myName + DATAVALNAME, this.valName);
            this.locPref.putLong(this.myName + ADDOFFSET, this.offset);
            this.locPref.putDouble(this.myName + SCALEFACTOR, this.scaleFactor);
        }
    }

    private LinkedList<c_int> getAllPossibleProducers() {
        LinkedList<c_int> params = DataStorage.naviData.getList();
        params.addAll(DataStorage.FCDebugOut.getList());
        return params;
    }

    private LinkedList<String> getAllAliases() {
        LinkedList<String> ret = new LinkedList<String>();
        ret.add(CONSTALIAS);
        for (c_int c : this.getAllPossibleProducers()) {
            ret.add(c.toString());
        }
        return ret;
    }

    public JComponent getChangeComponent() {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (!this.valName.equals(this.listModel.get(i).toString())) continue;
            this.list.setSelectedIndex(i);
            break;
        }
        return this.myComponent;
    }

    public long getRawValue() {
        if (CONSTALIAS.equals(this.valName)) {
            return 0L;
        }
        for (c_int c : this.getAllPossibleProducers()) {
            if (!this.valName.equals(c.toString())) continue;
            return c.value;
        }
        return Long.MIN_VALUE;
    }

    public double getValue() {
        return (double)(this.getRawValue() + this.offset) * this.scaleFactor;
    }

    private void initMyComponent() {
        this.myComponent = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.listModel = new DefaultListModel();
        for (String c : this.getAllAliases()) {
            this.listModel.addElement(c);
        }
        this.list = new JList(this.listModel);
        gbc.gridheight = 4;
        this.myComponent.add((Component)new JScrollPane(this.list), gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        this.myComponent.add((Component)new JLabel(ADDOFFSET), gbc);
        ++gbc.gridy;
        this.offsetField = new JTextField(String.valueOf(this.offset));
        this.myComponent.add((Component)this.offsetField, gbc);
        ++gbc.gridy;
        this.myComponent.add((Component)new JLabel(SCALEFACTOR), gbc);
        ++gbc.gridy;
        this.scaleField = new JTextField(String.valueOf(this.scaleFactor));
        this.myComponent.add((Component)this.scaleField, gbc);
    }
}

