/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow.elements;

import de.mylifesucks.oss.graphichelpers.DrawStringHelpers;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.DrawableElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.c_intElement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StringElement
extends DrawableElement {
    public static final String SPRINTFSTRING = "sprintf String";
    public static final String DECIMALS = "Number of decimals after coma";
    public static final String MAXSIZE = "Draw Text centered & as big as possible (computed before transformations)";
    public static final String FONTNAME = "Name of the Font";
    public static final String STANDARDFONT = "Dialog";
    public static final String TEXTXPOS = "X position of the text";
    public static final String TEXTXPOSPERCENT = "X position is % of width";
    public static final String TEXTYPOS = "Y position of the text";
    public static final String TEXTYPOSPERCENT = "Y position is % of height";
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private static ArrayList<String> fontMap;
    private c_intElement value;
    private c_intElement textSize;
    private c_intElement textXPos;
    private c_intElement textYPos;
    private JTextField sprintfTextField;
    private JTextField decimalsTextField;
    private JComboBox fontNames;
    private JCheckBox maxSize;
    private JCheckBox textXPosPercent;
    private JCheckBox textYPosPercent;

    public StringElement(Preferences nodePref, String name) {
        super(nodePref, name);
        this.value = new c_intElement(this.myPref, this.myName + "value");
        this.textSize = new c_intElement(this.myPref, this.myName + "textSize");
        this.textXPos = new c_intElement(this.myPref, this.myName + "textXPos");
        this.textYPos = new c_intElement(this.myPref, this.myName + "textYPos");
        this.initMyComponent();
    }

    private String getTextValue() {
        return this.myPref.get(this.myName + SPRINTFSTRING, "value: %s");
    }

    private int getDecimals() {
        return this.myPref.getInt(this.myName + DECIMALS, 0);
    }

    private boolean getMaxSize() {
        return this.myPref.getBoolean(this.myName + MAXSIZE, true);
    }

    private boolean getTextXPosPercent() {
        return this.myPref.getBoolean(this.myName + TEXTXPOSPERCENT, true);
    }

    private boolean getTextYPosPercent() {
        return this.myPref.getBoolean(this.myName + TEXTYPOSPERCENT, true);
    }

    protected void initMyComponent() {
        super.initMyComponent();
        JPanel panel = (JPanel)this.myComponent;
        this.gbc.gridwidth = 0;
        panel.add((Component)new JLabel(SPRINTFSTRING), this.gbc);
        ++this.gbc.gridy;
        this.sprintfTextField = new JTextField(this.getTextValue());
        this.sprintfTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
            }
        });
        panel.add((Component)this.sprintfTextField, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)new JLabel(FONTNAME), this.gbc);
        if (fontMap == null) {
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] af = e.getAllFonts();
            Object[] afn = new String[af.length];
            int i = 0;
            for (Font f : af) {
                afn[i++] = f.getName();
            }
            Arrays.sort(afn);
            fontMap = new ArrayList(afn.length);
            for (Object s : afn) {
                fontMap.add((String)s);
            }
        }
        this.fontNames = new JComboBox<Object>(fontMap.toArray());
        this.fontNames.setSelectedItem(this.myPref.get(this.myName + FONTNAME, STANDARDFONT));
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)this.fontNames, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)new JLabel(DECIMALS), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.decimalsTextField = new JTextField(String.valueOf(this.getDecimals()));
        panel.add((Component)this.decimalsTextField, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)new JLabel("Monitored Value"), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)this.value.getChangeComponent(), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)new JLabel("Textsize"), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)this.textSize.getChangeComponent(), this.gbc);
        this.maxSize = new JCheckBox(MAXSIZE);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.maxSize.setSelected(this.getMaxSize());
        panel.add((Component)this.maxSize, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)new JLabel("Position"), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)this.textXPos.getChangeComponent(), this.gbc);
        this.textXPosPercent = new JCheckBox(TEXTXPOSPERCENT);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.textXPosPercent.setSelected(this.getTextXPosPercent());
        panel.add((Component)this.textXPosPercent, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        panel.add((Component)this.textYPos.getChangeComponent(), this.gbc);
        this.textYPosPercent = new JCheckBox(TEXTYPOSPERCENT);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.textYPosPercent.setSelected(this.getTextYPosPercent());
        panel.add((Component)this.textYPosPercent, this.gbc);
    }

    protected void extraPersist() {
        this.myPref.put(this.myName + SPRINTFSTRING, this.sprintfTextField.getText());
        this.value.persist(this.myName + "value");
        this.textSize.persist(this.myName + "textSize");
        this.textXPos.persist(this.myName + "textXPos");
        this.textYPos.persist(this.myName + "textYPos");
        try {
            int i = Integer.valueOf(this.decimalsTextField.getText());
            this.myPref.putInt(this.myName + DECIMALS, i);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myPref.putBoolean(this.myName + MAXSIZE, this.maxSize.isSelected());
        this.myPref.putBoolean(this.myName + TEXTXPOSPERCENT, this.textXPosPercent.isSelected());
        this.myPref.putBoolean(this.myName + TEXTYPOSPERCENT, this.textYPosPercent.isSelected());
        if (this.fontNames.getSelectedIndex() < 0 || this.fontNames.getSelectedIndex() > this.fontNames.getSelectedObjects().length) {
            this.fontNames.setSelectedItem(0);
        }
        this.myPref.put(this.myName + FONTNAME, this.fontNames.getSelectedObjects()[0].toString());
    }

    public String valueToString() {
        String drawString = this.getTextValue();
        try {
            String me = decimalFormat.format(this.value.getValue());
            int decimals = this.getDecimals();
            me = me.replace(",", ".");
            if (me.contains(".")) {
                while (me.substring(me.indexOf(".")).length() < decimals + 1) {
                    me = me + "0";
                }
                if (decimals == 0) {
                    me = me.substring(0, me.indexOf("."));
                }
            } else {
                while (me.length() < decimals + 1) {
                    me = "0" + me;
                }
                if (decimals > 0) {
                    me = me.substring(0, me.length() - decimals) + "." + me.substring(me.length() - decimals);
                }
            }
            if (decimals > 0 && me.substring(me.indexOf(".")).length() > decimals) {
                me = me.substring(0, me.indexOf(".") + decimals + 1);
            }
            drawString = String.format(this.getTextValue(), me);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        return drawString;
    }

    public void drawTo(Graphics2D g2d, Dimension d) {
        g2d.setColor(this.getForegroundColor(true));
        g2d.setFont(new Font(this.fontNames.getSelectedItem().toString(), 0, (int)this.textSize.getValue()));
        String drawString = this.valueToString();
        if (this.getMaxSize()) {
            DrawStringHelpers.drawStringBiggest(g2d, d, drawString);
        } else {
            DrawStringHelpers.drawStringAtPos(g2d, d, drawString, (int)this.textSize.getValue(), this.textXPos.getValue(), this.getTextXPosPercent(), this.textYPos.getValue(), this.getTextYPosPercent());
        }
    }
}

