/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow.elements;

import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.AbstractElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DrawableElement
extends AbstractElement {
    protected JButton foregroundTransparencyButton;
    protected JButton backgroundTransparencyButton;
    protected JButton foregroundColorButton;
    protected JButton backgroundColorButton;
    protected JPanel foregroundColorLabel;
    protected JPanel backgroundColorLabel;
    protected JOptionPane customOptionPane;
    protected GridBagConstraints gbc;
    public static final String FOREGROUND = "Foreground";
    public static final String FOREGROUNDCOLOR = "Foreground Color";
    public static final String FOREGROUNDCOLORR = "Foreground ColorRED";
    public static final String FOREGROUNDCOLORG = "Foreground ColorGREEN";
    public static final String FOREGROUNDCOLORB = "Foreground ColorBLUE";
    public static final String FOREGROUNDTRANSPARENCY = "Foreground Transparency";
    public static final String BACKGROUND = "Background";
    public static final String BACKGROUNDCOLOR = "Background Color";
    public static final String BACKGROUNDCOLORR = "Background ColorRED";
    public static final String BACKGROUNDCOLORG = "Background ColorGREEN";
    public static final String BACKGROUNDCOLORB = "Background ColorBLUE";
    public static final String BACKGROUNDTRANSPARENCY = "Background Transparency";
    private Color foreGroundColor = this.getForegroundColor(false);
    private JButton src;

    public abstract void drawTo(Graphics2D var1, Dimension var2);

    public DrawableElement(Preferences rootPref, String name) {
        super(rootPref, name);
    }

    protected Color getForegroundColor(boolean withAlpha) {
        if (withAlpha) {
            return new Color(this.myPref.getInt(this.myName + FOREGROUNDCOLORR, 255), this.myPref.getInt(this.myName + FOREGROUNDCOLORG, 0), this.myPref.getInt(this.myName + FOREGROUNDCOLORB, 0), this.getForegroundTransparency());
        }
        return new Color(this.myPref.getInt(this.myName + FOREGROUNDCOLORR, 255), this.myPref.getInt(this.myName + FOREGROUNDCOLORG, 0), this.myPref.getInt(this.myName + FOREGROUNDCOLORB, 0));
    }

    protected void setForegroundColor(Color color) {
        this.foreGroundColor = color;
        this.myPref.putInt(this.myName + FOREGROUNDCOLORR, color.getRed());
        this.myPref.putInt(this.myName + FOREGROUNDCOLORG, color.getGreen());
        this.myPref.putInt(this.myName + FOREGROUNDCOLORB, color.getBlue());
        if (this.foregroundColorLabel != null) {
            this.foregroundColorLabel.setBackground(color);
        }
    }

    protected int getForegroundTransparency() {
        return this.myPref.getInt(this.myName + FOREGROUNDTRANSPARENCY, 255);
    }

    protected void setForegroundTransparency(int value) {
        this.myPref.putInt(this.myName + FOREGROUNDTRANSPARENCY, value);
    }

    protected Color getBackgroundColor() {
        return new Color(this.myPref.getInt(this.myName + BACKGROUNDCOLORR, 0), this.myPref.getInt(this.myName + BACKGROUNDCOLORG, 0), this.myPref.getInt(this.myName + BACKGROUNDCOLORB, 0));
    }

    protected void setBackgroundColor(Color color) {
        this.myPref.putInt(this.myName + BACKGROUNDCOLORR, color.getRed());
        this.myPref.putInt(this.myName + BACKGROUNDCOLORG, color.getGreen());
        this.myPref.putInt(this.myName + BACKGROUNDCOLORB, color.getBlue());
        this.backgroundColorLabel.setBackground(color);
    }

    protected int getBackgroundTransparency() {
        return this.myPref.getInt(this.myName + BACKGROUNDTRANSPARENCY, 255);
    }

    protected void setBackgroundTransparency(int value) {
        this.myPref.putInt(this.myName + BACKGROUNDTRANSPARENCY, value);
    }

    protected void initMyComponent() {
        this.myComponent = new JPanel(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.myComponent.add((Component)new JLabel(FOREGROUND), this.gbc);
        ++this.gbc.gridx;
        this.foregroundColorLabel = new JPanel();
        this.foregroundColorLabel.setBackground(this.getForegroundColor(false));
        this.myComponent.add((Component)this.foregroundColorLabel, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.foregroundColorButton = new JButton(FOREGROUNDCOLOR);
        this.foregroundTransparencyButton = new JButton(FOREGROUNDTRANSPARENCY);
        this.myComponent.add((Component)this.foregroundColorButton, this.gbc);
        ++this.gbc.gridx;
        this.myComponent.add((Component)this.foregroundTransparencyButton, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        ++this.gbc.gridx;
        this.backgroundColorLabel = new JPanel();
        this.backgroundColorLabel.setBackground(this.getBackgroundColor());
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.backgroundColorButton = new JButton(BACKGROUNDCOLOR);
        this.backgroundTransparencyButton = new JButton(BACKGROUNDTRANSPARENCY);
        ++this.gbc.gridx;
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawableElement.this.src = (JButton)e.getSource();
                if (DrawableElement.this.src == DrawableElement.this.foregroundColorButton || DrawableElement.this.src == DrawableElement.this.backgroundColorButton) {
                    JButton localsrc = DrawableElement.this.src;
                    JColorChooser cc = new JColorChooser(localsrc == DrawableElement.this.foregroundColorButton ? DrawableElement.this.getForegroundColor(false) : DrawableElement.this.getBackgroundColor());
                    JDialog dialog = JColorChooser.createDialog(DrawableElement.this.myComponent, "Change " + (localsrc == DrawableElement.this.foregroundColorButton ? DrawableElement.FOREGROUNDCOLOR : DrawableElement.BACKGROUNDCOLOR), true, cc, this, null);
                    dialog.setVisible(true);
                    dialog.toFront();
                    if (localsrc == DrawableElement.this.foregroundColorButton) {
                        DrawableElement.this.setForegroundColor(cc.getColor());
                    } else {
                        DrawableElement.this.setBackgroundColor(cc.getColor());
                    }
                } else if (DrawableElement.this.src == DrawableElement.this.foregroundTransparencyButton || DrawableElement.this.src == DrawableElement.this.backgroundTransparencyButton) {
                    DrawableElement.this.customOptionPane = new JOptionPane();
                    JSlider slider = new JSlider();
                    slider.setMajorTickSpacing(50);
                    slider.setPaintTicks(true);
                    slider.setPaintLabels(true);
                    slider.setMinimum(0);
                    slider.setMaximum(255);
                    slider.setValue(DrawableElement.this.src == DrawableElement.this.foregroundTransparencyButton ? DrawableElement.this.getForegroundTransparency() : DrawableElement.this.getBackgroundTransparency());
                    ChangeListener changeListener = new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            JSlider theSlider = (JSlider)changeEvent.getSource();
                            if (!theSlider.getValueIsAdjusting()) {
                                DrawableElement.this.customOptionPane.setInputValue(new Integer(theSlider.getValue()));
                                if (DrawableElement.this.src == DrawableElement.this.foregroundTransparencyButton) {
                                    DrawableElement.this.setForegroundTransparency(Integer.valueOf(DrawableElement.this.customOptionPane.getInputValue().toString()));
                                } else {
                                    DrawableElement.this.setBackgroundTransparency(Integer.valueOf(DrawableElement.this.customOptionPane.getInputValue().toString()));
                                }
                            }
                        }
                    };
                    slider.addChangeListener(changeListener);
                    DrawableElement.this.customOptionPane.setInputValue(new Integer(slider.getValue()));
                    DrawableElement.this.customOptionPane.setMessage(new Object[]{DrawableElement.this.src == DrawableElement.this.foregroundTransparencyButton ? DrawableElement.FOREGROUNDTRANSPARENCY : "Background Transparency: ", slider});
                    DrawableElement.this.customOptionPane.setMessageType(-1);
                    DrawableElement.this.customOptionPane.setOptionType(0);
                    JDialog dialog = DrawableElement.this.customOptionPane.createDialog(DrawableElement.this.myComponent, DrawableElement.this.src == DrawableElement.this.foregroundTransparencyButton ? DrawableElement.FOREGROUNDTRANSPARENCY : DrawableElement.BACKGROUNDTRANSPARENCY);
                    dialog.setVisible(true);
                    dialog.toFront();
                }
            }
        };
        this.foregroundColorButton.addActionListener(buttonListener);
        this.foregroundTransparencyButton.addActionListener(buttonListener);
        this.backgroundColorButton.addActionListener(buttonListener);
        this.backgroundTransparencyButton.addActionListener(buttonListener);
    }

    public void persist(int num) {
        super.persist(num);
        this.setForegroundColor(this.foreGroundColor);
    }

    public synchronized JComponent getChangeComponent() {
        return super.getChangeComponent();
    }
}

