/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow.elements;

import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.BarElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.RotateTransformation;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.ShiftTransformation;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.StringElement;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement {
    public static final String NODENAME = "Elements";
    public static final String CLASSTYPE = "CLASSTYPE";
    protected Preferences myPref;
    protected JComponent myComponent;
    protected String myName;

    public AbstractElement(Preferences rootNode, String myName) {
        this.myPref = rootNode.node(NODENAME);
        this.myName = myName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.myName;
    }

    public void persist(int num) {
        this.myPref.remove(this.myName + CLASSTYPE);
        this.myName = String.valueOf(num);
        this.myPref.put(this.myName + CLASSTYPE, this.getClass().getSimpleName());
        this.extraPersist();
    }

    public void dispose() {
        this.myPref.remove(this.myName + CLASSTYPE);
        try {
            this.myPref.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(AbstractElement.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected abstract void extraPersist();

    public static AbstractElement elementFromString(Preferences rootpref, String className, int i) {
        if (className.equals(BarElement.class.getSimpleName())) {
            return new BarElement(rootpref, String.valueOf(i));
        }
        if (className.equals(StringElement.class.getSimpleName())) {
            return new StringElement(rootpref, String.valueOf(i));
        }
        if (className.equals(RotateTransformation.class.getSimpleName())) {
            return new RotateTransformation(rootpref, String.valueOf(i));
        }
        if (className.equals(ShiftTransformation.class.getSimpleName())) {
            return new ShiftTransformation(rootpref, String.valueOf(i));
        }
        return null;
    }

    public static LinkedList<AbstractElement> load(Preferences rootpref) {
        LinkedList<AbstractElement> ret = new LinkedList<AbstractElement>();
        int i = 0;
        Preferences nodePref = rootpref.node(NODENAME);
        while (!CLASSTYPE.equals(nodePref.get(i + CLASSTYPE, CLASSTYPE))) {
            String className = nodePref.get(i + CLASSTYPE, CLASSTYPE);
            AbstractElement elem = AbstractElement.elementFromString(rootpref, className, i);
            if (elem != null) {
                ret.add(elem);
            }
            ++i;
        }
        return ret;
    }

    protected abstract void initMyComponent();

    public synchronized JComponent getChangeComponent() {
        if (this.myComponent == null) {
            this.initMyComponent();
        }
        return this.myComponent;
    }
}

