/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.DataWindow;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataWindowPanel
extends JPanel
implements ActionListener {
    JList dataWindowJList;
    public DefaultListModel listModel;
    JButton show;
    JButton hide;
    JButton tofront;
    JButton toback;
    JButton expo;
    JButton impo;
    JButton dispo;

    public DataWindowPanel() {
        super(new BorderLayout());
        DataStorage.dataWindowPanel = this;
        Box verticalBox = Box.createVerticalBox();
        final JButton newWindowb = new JButton("New Datawindow");
        newWindowb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataWindow newWindow = new DataWindow(null);
                newWindow.setLocation(newWindowb.getLocationOnScreen());
                DataWindow.addDataWindow(newWindow);
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalGlue());
        hBox.add(newWindowb);
        hBox.add(Box.createHorizontalGlue());
        verticalBox.add(hBox);
        this.listModel = new DefaultListModel();
        this.dataWindowJList = new JList(this.listModel);
        this.dataWindowJList.setMinimumSize(new Dimension(100, 100));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalGlue());
        hBox.add(new JScrollPane(this.dataWindowJList));
        hBox.add(Box.createHorizontalGlue());
        verticalBox.add(hBox);
        this.show = new JButton("Show");
        this.hide = new JButton("Hide");
        this.tofront = new JButton("To Front");
        this.toback = new JButton("To Back");
        this.dispo = new JButton("Dispose");
        this.expo = new JButton("Export");
        this.impo = new JButton("Import");
        this.show.addActionListener(this);
        this.hide.addActionListener(this);
        this.tofront.addActionListener(this);
        this.toback.addActionListener(this);
        this.dispo.addActionListener(this);
        this.expo.addActionListener(this);
        this.impo.addActionListener(this);
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.show);
        hBox.add(this.hide);
        hBox.add(this.tofront);
        hBox.add(this.toback);
        hBox.add(this.dispo);
        hBox.add(this.expo);
        hBox.add(this.impo);
        hBox.add(Box.createHorizontalGlue());
        verticalBox.add(hBox);
        this.add(verticalBox);
    }

    public void addDataWindow(DataWindow dw) {
        this.listModel.addElement(dw);
    }

    public void removeDataWindow(DataWindow dw) {
        this.listModel.removeElement(dw);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.impo) {
            block33: {
                try {
                    JFileChooser fc = new JFileChooser();
                    int returnVal = fc.showOpenDialog(this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        try {
                            DocumentBuilder db = dbf.newDocumentBuilder();
                            Document doc = db.parse(file);
                            doc.getDocumentElement().normalize();
                            NodeList nodeLst = doc.getElementsByTagName("node");
                            String loadId = "";
                            for (int s = 0; s < nodeLst.getLength(); ++s) {
                                Node fstNode = nodeLst.item(s);
                                if (fstNode.getNodeType() != 1) continue;
                                Element fstElmnt = (Element)fstNode;
                                loadId = fstElmnt.getAttribute("name");
                            }
                            DataWindow changed = null;
                            for (DataWindow dw : DataStorage.dataWindows) {
                                if (!loadId.equals(dw.myId)) continue;
                                System.err.println("Damn, window exists... Renaming existing one");
                                changed = dw;
                                break;
                            }
                            if (changed != null) {
                                DataWindow.removeDataWindow(changed);
                                changed.myId = DataWindow.createNewWindowID();
                                changed.persistWindow();
                                DataWindow.addDataWindow(changed);
                            }
                            System.out.println("ready to load " + loadId);
                            try {
                                Preferences.importPreferences(new BufferedInputStream(new FileInputStream(file)));
                            }
                            catch (InvalidPreferencesFormatException ex) {
                                System.err.println("failed to load " + loadId + " because: " + ex);
                                return;
                            }
                        }
                        catch (SAXException ex) {
                            Logger.getLogger(DataWindowPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ParserConfigurationException ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                        }
                        DataWindow.init();
                        System.out.println("Loaded from : " + file.getName() + "." + "\n");
                        break block33;
                    }
                    System.out.println("Open command cancelled by user.\n");
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
            return;
        }
        int index = this.dataWindowJList.getSelectedIndex();
        if (index < 0 || index > this.listModel.getSize() - 1) {
            return;
        }
        Object select = this.listModel.getElementAt(index);
        if (select instanceof DataWindow) {
            DataWindow current = (DataWindow)select;
            if (src == this.show) {
                current.setVisible(true);
            } else if (src == this.hide) {
                current.setVisible(false);
            } else if (src == this.tofront) {
                current.toFront();
            } else if (src == this.toback) {
                current.toBack();
            } else if (src == this.dispo) {
                DataWindow.removeDataWindow(current);
            } else if (src == this.expo) {
                try {
                    JFileChooser fc = new JFileChooser();
                    int returnVal = fc.showSaveDialog(this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        current.getMyPref().exportSubtree(new BufferedOutputStream(new FileOutputStream(file)));
                        System.out.println("Saved to : " + file.getName() + "." + "\n");
                    } else {
                        System.out.println("Save command cancelled by user.\n");
                    }
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
                catch (BackingStoreException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

