/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui.datawindow;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.datatypes.c_int;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.AbstractElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.BarElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.DrawableElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.RotateTransformation;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.ShiftTransformation;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.StringElement;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.elements.Transformation;
import de.mylifesucks.oss.ncsimulator.gui.tray.SimTray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.RepaintManager;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataWindow
extends JWindow {
    public static final String WINDOWS_PREFERENCE_NODE_NAME = "datawindow";
    public String myId = DataWindow.createNewWindowID();
    private Preferences myPref;
    private boolean mMoveStart = false;
    boolean mHozResizeEnabled = false;
    boolean mVerResizeEnabled = false;
    private Point mWindowMouseClickPoint;
    private static int arcw = 5;
    private static int arch = 5;
    boolean mInvert = false;
    private Color bgColor = Color.BLACK;
    private boolean opaque = false;
    public static final String SIZEX = "SizeX";
    public static final String SIZEY = "SizeY";
    public static final String POSX = "PositionX";
    public static final String POSY = "PositionY";
    public static final String BGCOLOR = "Background Color";
    public static final String OPAQUE = "Opaque";
    public static final String BACKGROUNDTRANSPARENTVALUE = "Background Tansparency";
    private int backgroundtransparentvalue = 255;
    private DataPanel dataPanel;
    private Method mSetWindowOpacity = null;
    private Method mSetWindowOpaque = null;
    private Method mSetWindowShape = null;
    private Method mIsTranslucencySupported = null;
    private boolean firstRun = true;
    private Class<?> awtUtilitiesClass;
    private Class<?> translucencyClass;
    private Object TRANSLUCENT = null;
    private DefaultListModel elementsListModel;
    private JList elementsList;
    private JSplitPane elementsPanel;
    private JPanel elementsDialogPanel;
    JButton addElementButton;
    JButton removeElementButton;
    JButton commitButton;
    JButton upButton;
    JButton downButton;
    JComboBox possibleElements;

    public DataWindow(String spawnId) {
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        if (spawnId != null) {
            this.myId = spawnId;
        }
        this.dataPanel = new DataPanel();
        try {
            this.awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            this.mSetWindowOpacity = this.awtUtilitiesClass.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            this.mSetWindowOpaque = this.awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            this.mSetWindowShape = this.awtUtilitiesClass.getMethod("setWindowShape", Window.class, Shape.class);
            this.translucencyClass = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            this.mIsTranslucencySupported = this.awtUtilitiesClass.getMethod("isTranslucencySupported", this.translucencyClass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myPref = DataStorage.preferences.node(WINDOWS_PREFERENCE_NODE_NAME).node(this.myId);
        this.elementsListModel = new DefaultListModel();
        this.elementsList = new JList(this.elementsListModel);
        this.elementsList.addListSelectionListener(new MyListSelectionHandler());
        this.elementsDialogPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.addElementButton = new JButton("add");
        this.addElementButton.addActionListener(this.dataPanel);
        this.removeElementButton = new JButton("remove");
        this.removeElementButton.addActionListener(this.dataPanel);
        this.commitButton = new JButton("commit");
        this.commitButton.addActionListener(this.dataPanel);
        this.upButton = new JButton("UP");
        this.upButton.addActionListener(this.dataPanel);
        this.downButton = new JButton("down");
        this.downButton.addActionListener(this.dataPanel);
        this.elementsPanel = new JSplitPane();
        this.elementsPanel.setDividerLocation(200);
        this.elementsPanel.setResizeWeight(0.0);
        this.elementsDialogPanel.add((Component)this.elementsPanel, "Center");
        this.possibleElements = new JComboBox<String>(new String[]{StringElement.class.getSimpleName(), BarElement.class.getSimpleName(), RotateTransformation.class.getSimpleName(), ShiftTransformation.class.getSimpleName()});
        buttonPanel.add(this.possibleElements);
        buttonPanel.add(this.addElementButton);
        buttonPanel.add(this.removeElementButton);
        buttonPanel.add(this.commitButton);
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
        this.elementsDialogPanel.add((Component)buttonPanel, "South");
        this.setSize(this.myPref.getInt(SIZEX, 300), this.myPref.getInt(SIZEY, 300));
        this.setLocation(this.myPref.getInt(POSX, 300), this.myPref.getInt(POSY, 300));
        this.bgColor = new Color(this.myPref.getInt(BGCOLOR, this.bgColor.getRGB()), true);
        this.backgroundtransparentvalue = this.myPref.getInt(BACKGROUNDTRANSPARENTVALUE, this.backgroundtransparentvalue);
        this.opaque = this.myPref.getBoolean(OPAQUE, this.opaque);
        if (this.mIsTranslucencySupported != null && this.mSetWindowOpacity != null && this.mSetWindowOpaque != null) {
            try {
                String os;
                for (Object o : this.translucencyClass.getEnumConstants()) {
                    if (!o.toString().equals("TRANSLUCENT")) continue;
                    this.TRANSLUCENT = o;
                    break;
                }
                if ((os = System.getProperty("os.name")).toLowerCase().contains("linux")) {
                    // empty if block
                }
                if (this.TRANSLUCENT != null && this.mSetWindowOpaque != null && ((Boolean)this.mIsTranslucencySupported.invoke((Object)this, this.TRANSLUCENT)).booleanValue()) {
                    this.mSetWindowOpaque.invoke(null, this, this.opaque);
                    if (!this.opaque) {
                        this.mSetWindowOpacity.invoke(null, this, Float.valueOf(1.0f));
                    } else {
                        this.mSetWindowOpacity.invoke(null, this, Float.valueOf(0.5f));
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(DataWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                RoundRectangle2D.Float shape = new RoundRectangle2D.Float(0.0f, 0.0f, DataWindow.this.getWidth(), DataWindow.this.getHeight(), arcw, arch);
                try {
                    DataWindow.this.mSetWindowShape.invoke(null, this, shape);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        for (AbstractElement a : AbstractElement.load(this.myPref)) {
            this.elementsListModel.addElement(a);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.dataPanel, "Center");
        this.setVisible(true);
        this.setAlwaysOnTop(true);
    }

    public Preferences getMyPref() {
        return this.myPref;
    }

    public static String createNewWindowID() {
        return "window" + Calendar.getInstance().getTime().getTime() + "-" + Math.random();
    }

    public String toString() {
        return this.myId + " at: " + this.getLocation().x + "/" + this.getLocation().y;
    }

    public static void addDataWindow(DataWindow dw) {
        DataStorage.dataWindows.add(dw);
        DataStorage.dataWindowPanel.addDataWindow(dw);
    }

    public static void removeDataWindow(DataWindow dw) {
        dw.setVisible(false);
        DataStorage.dataWindows.remove(dw);
        DataStorage.dataWindowPanel.removeDataWindow(dw);
        dw.dispose();
        try {
            dw.myPref.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void init() {
        try {
            for (String s : DataStorage.preferences.node(WINDOWS_PREFERENCE_NODE_NAME).childrenNames()) {
                boolean exists = false;
                for (DataWindow dw : DataStorage.dataWindows) {
                    if (!s.equals(dw.myId)) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    DataWindow.addDataWindow(new DataWindow(s));
                    continue;
                }
                System.out.println("no init because exists");
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void disposeWindow() {
        DataWindow.removeDataWindow(this);
    }

    public void persistWindow() {
        this.myPref = DataStorage.preferences.node(WINDOWS_PREFERENCE_NODE_NAME).node(this.myId);
        this.myPref.putInt(SIZEX, this.getSize().width);
        this.myPref.putInt(SIZEY, this.getSize().height);
        this.myPref.putInt(POSX, this.getLocation().x);
        this.myPref.putInt(POSY, this.getLocation().y);
        this.myPref.putInt(BGCOLOR, this.bgColor.getRGB());
        this.myPref.putInt(BACKGROUNDTRANSPARENTVALUE, this.backgroundtransparentvalue);
        this.myPref.putBoolean(OPAQUE, this.opaque);
        for (int i = 0; i < this.elementsListModel.size(); ++i) {
            Object elem = this.elementsListModel.get(i);
            if (elem == null || !(elem instanceof AbstractElement)) continue;
            ((AbstractElement)elem).persist(i);
        }
        try {
            this.myPref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private AbstractElement getSelectedElement() {
        AbstractElement a = (AbstractElement)this.elementsList.getSelectedValue();
        if (a != null && a instanceof AbstractElement) {
            return a;
        }
        return null;
    }

    class DataPanel
    extends JPanel
    implements ActionListener,
    Observer,
    ChangeListener {
        JColorChooser cc;
        JMenuItem disposeItem;
        JMenuItem elementsItem;
        JMenuItem bgChoose;
        JMenuItem backgroundtransparentChoose;
        JMenuItem selected;
        JMenuItem renameItem;
        JOptionPane customOptionPane;

        public DataPanel() {
            DataStorage.naviData.addObserver(this);
            DataStorage.FCDebugOut.addObserver(this);
            this.addMouseMotionListener(new MouseAdapter(){

                public void mouseDragged(MouseEvent e) {
                    Point point = e.getPoint();
                    if (DataWindow.this.mMoveStart) {
                        int musDiffX = point.x - ((DataWindow)DataWindow.this).mWindowMouseClickPoint.x;
                        int musDiffY = point.y - ((DataWindow)DataWindow.this).mWindowMouseClickPoint.y;
                        DataWindow.this.setLocation(DataWindow.this.getLocation().x + musDiffX, DataWindow.this.getLocation().y + musDiffY);
                    } else if (DataWindow.this.mHozResizeEnabled) {
                        int musDiffX = point.x - ((DataWindow)DataWindow.this).mWindowMouseClickPoint.x;
                        DataWindow.this.setSize(DataWindow.this.getWidth() + (DataWindow.this.mInvert ? -1 : 1) * musDiffX, DataWindow.this.getHeight());
                        ((DataWindow)DataWindow.this).mWindowMouseClickPoint.x = point.x;
                    } else if (DataWindow.this.mVerResizeEnabled) {
                        int musDiffY = point.y - ((DataWindow)DataWindow.this).mWindowMouseClickPoint.y;
                        DataWindow.this.setSize(DataWindow.this.getWidth(), DataWindow.this.getHeight() + (DataWindow.this.mInvert ? -1 : 1) * musDiffY);
                        ((DataWindow)DataWindow.this).mWindowMouseClickPoint.y = point.y;
                    }
                }

                public void mouseMoved(MouseEvent e) {
                    if (e.getX() >= DataPanel.this.getWidth() - 5) {
                        DataPanel.this.setCursor(new Cursor(10));
                    } else if (e.getY() >= DataPanel.this.getHeight() - 5) {
                        DataPanel.this.setCursor(new Cursor(9));
                    } else {
                        DataPanel.this.setCursor(new Cursor(13));
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent e) {
                    DataPanel.this.setCursor(new Cursor(0));
                }

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        if (e.getX() >= DataPanel.this.getWidth() - 5) {
                            DataWindow.this.mHozResizeEnabled = true;
                        } else if (e.getY() >= DataPanel.this.getHeight() - 5) {
                            DataWindow.this.mVerResizeEnabled = true;
                        } else {
                            DataWindow.this.mMoveStart = true;
                        }
                        DataWindow.this.mInvert = e.getX() < 5 || e.getY() < 5;
                        DataWindow.this.mWindowMouseClickPoint = e.getPoint();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (DataWindow.this.mMoveStart || DataWindow.this.mVerResizeEnabled || DataWindow.this.mHozResizeEnabled) {
                        DataWindow.this.persistWindow();
                    }
                    DataWindow.this.mMoveStart = false;
                    DataWindow.this.mVerResizeEnabled = false;
                    DataWindow.this.mHozResizeEnabled = false;
                }
            });
            this.setOpaque(false);
            JPopupMenu popup = new JPopupMenu();
            this.renameItem = new JMenuItem("Rename");
            this.renameItem.addActionListener(this);
            popup.add(this.renameItem);
            this.bgChoose = new JMenuItem(DataWindow.BGCOLOR);
            this.bgChoose.addActionListener(this);
            popup.add(this.bgChoose);
            this.backgroundtransparentChoose = new JMenuItem(DataWindow.BACKGROUNDTRANSPARENTVALUE);
            popup.add(this.backgroundtransparentChoose);
            this.backgroundtransparentChoose.addActionListener(this);
            this.elementsItem = new JMenuItem("Edit Items");
            this.elementsItem.addActionListener(this);
            popup.add(this.elementsItem);
            popup.addSeparator();
            this.disposeItem = new JMenuItem("Dispose this window");
            this.disposeItem.addActionListener(this);
            popup.add(this.disposeItem);
            this.setComponentPopupMenu(popup);
        }

        public void update(Observable o, Object arg) {
            if (o instanceof c_int) {
                Runnable r = new Runnable(){

                    public void run() {
                        DataWindow.this.firstRun = false;
                        DataPanel.this.repaint();
                    }
                };
                DataStorage.executors.submit(r);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.disposeItem) {
                DataWindow.this.disposeWindow();
            } else if (e.getSource() == this.bgChoose) {
                this.cc = new JColorChooser(DataWindow.this.bgColor);
                JDialog dialog = JColorChooser.createDialog(this, "Change Background Color", true, this.cc, this, null);
                this.selected = this.bgChoose;
                this.cc.getSelectionModel().addChangeListener(this);
                DataWindow.this.setAlwaysOnTop(false);
                dialog.setVisible(true);
                dialog.toFront();
            } else if (e.getSource() == DataWindow.this.addElementButton) {
                String type = DataWindow.this.possibleElements.getSelectedItem().toString();
                AbstractElement elem = AbstractElement.elementFromString(DataWindow.this.myPref, type, DataWindow.this.elementsListModel.size());
                if (elem != null) {
                    DataWindow.this.elementsListModel.addElement(elem);
                }
            } else if (e.getSource() == DataWindow.this.commitButton) {
                DataWindow.this.persistWindow();
                this.repaint();
            } else if (e.getSource() == DataWindow.this.removeElementButton) {
                if (DataWindow.this.getSelectedElement() != null) {
                    int index = DataWindow.this.elementsList.getSelectedIndex();
                    AbstractElement a = DataWindow.this.getSelectedElement();
                    DataWindow.this.elementsListModel.remove(index);
                    a.dispose();
                    for (int i = index; i < DataWindow.this.elementsListModel.getSize(); ++i) {
                        AbstractElement curr = (AbstractElement)DataWindow.this.elementsListModel.get(i);
                        curr.persist(i);
                        DataWindow.this.elementsListModel.remove(i);
                        DataWindow.this.elementsListModel.add(i, curr);
                    }
                }
            } else if (e.getSource() == DataWindow.this.upButton) {
                int index = DataWindow.this.elementsList.getSelectedIndex();
                if (index > 0) {
                    AbstractElement curr = (AbstractElement)DataWindow.this.elementsListModel.get(index);
                    AbstractElement prev = (AbstractElement)DataWindow.this.elementsListModel.get(index - 1);
                    DataWindow.this.elementsListModel.remove(index);
                    DataWindow.this.elementsListModel.remove(index - 1);
                    DataWindow.this.elementsListModel.add(index - 1, curr);
                    DataWindow.this.elementsListModel.add(index, prev);
                    curr.persist(index - 1);
                    prev.persist(index);
                    DataWindow.this.elementsList.setSelectedIndex(index - 1);
                }
            } else if (e.getSource() == DataWindow.this.downButton) {
                int index = DataWindow.this.elementsList.getSelectedIndex();
                if (index < DataWindow.this.elementsListModel.getSize() - 1) {
                    AbstractElement curr = (AbstractElement)DataWindow.this.elementsListModel.get(index);
                    AbstractElement next = (AbstractElement)DataWindow.this.elementsListModel.get(index + 1);
                    DataWindow.this.elementsListModel.remove(index + 1);
                    DataWindow.this.elementsListModel.remove(index);
                    DataWindow.this.elementsListModel.add(index, next);
                    DataWindow.this.elementsListModel.add(index + 1, curr);
                    curr.persist(index + 1);
                    next.persist(index);
                    DataWindow.this.elementsList.setSelectedIndex(index + 1);
                }
            } else if (e.getSource() == this.elementsItem) {
                DataWindow.this.elementsPanel.setLeftComponent(new JScrollPane(DataWindow.this.elementsList));
                if (DataWindow.this.elementsListModel.size() > 0) {
                    AbstractElement a;
                    if (DataWindow.this.elementsList.getSelectedIndex() != -1) {
                        a = (AbstractElement)DataWindow.this.elementsListModel.get(DataWindow.this.elementsList.getSelectedIndex());
                    } else {
                        a = (AbstractElement)DataWindow.this.elementsListModel.get(0);
                        DataWindow.this.elementsList.setSelectedIndex(0);
                    }
                    DataWindow.this.elementsPanel.setRightComponent(new JScrollPane(a.getChangeComponent()));
                } else {
                    DataWindow.this.elementsPanel.setRightComponent(new JScrollPane(new JPanel()));
                }
                Object[] options = new Object[]{"OK"};
                Object[] array = new Object[]{DataWindow.this.elementsDialogPanel};
                JOptionPane optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
                JDialog jd = new JDialog((Frame)SimTray.mainFrame, "Edit Elements");
                jd.setContentPane(optionPane);
                jd.setModal(true);
                jd.pack();
                jd.setLocationRelativeTo(DataWindow.this);
                jd.setDefaultCloseOperation(2);
                DataWindow.this.setAlwaysOnTop(false);
                jd.setVisible(true);
                DataWindow.this.setAlwaysOnTop(true);
            } else if (e.getSource() == this.renameItem) {
                JTextField name = new JTextField(DataWindow.this.myId);
                Object[] options = new Object[]{"OK"};
                Object[] array = new Object[]{name};
                JOptionPane optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
                JDialog jd = new JDialog((Frame)SimTray.mainFrame, "Rename Windows");
                jd.setContentPane(optionPane);
                jd.setModal(true);
                jd.pack();
                jd.setLocationRelativeTo(DataWindow.this);
                jd.setDefaultCloseOperation(2);
                DataWindow.this.setAlwaysOnTop(false);
                jd.setVisible(true);
                DataWindow.this.setAlwaysOnTop(true);
                DataWindow.this.myId = name.getText();
            } else if (e.getSource() == this.backgroundtransparentChoose) {
                this.customOptionPane = new JOptionPane();
                JSlider slider = new JSlider();
                slider.setMajorTickSpacing(50);
                slider.setPaintTicks(true);
                slider.setPaintLabels(true);
                slider.setMinimum(0);
                slider.setMaximum(255);
                slider.setValue(DataWindow.this.backgroundtransparentvalue);
                ChangeListener changeListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider theSlider = (JSlider)changeEvent.getSource();
                        DataPanel.this.customOptionPane.setInputValue(new Integer(theSlider.getValue()));
                        DataWindow.this.backgroundtransparentvalue = Integer.valueOf(DataPanel.this.customOptionPane.getInputValue().toString());
                        DataPanel.this.repaint();
                    }
                };
                slider.addChangeListener(changeListener);
                this.customOptionPane.setInputValue(new Integer(slider.getValue()));
                this.customOptionPane.setMessage(new Object[]{"Background Tansparency: ", slider});
                this.customOptionPane.setMessageType(-1);
                this.customOptionPane.setOptionType(0);
                JDialog dialog = this.customOptionPane.createDialog(DataWindow.this, DataWindow.BACKGROUNDTRANSPARENTVALUE);
                DataWindow.this.setAlwaysOnTop(false);
                dialog.setVisible(true);
                dialog.toFront();
                DataWindow.this.persistWindow();
            }
            DataWindow.this.setAlwaysOnTop(true);
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(new Color(DataWindow.this.bgColor.getRed(), DataWindow.this.bgColor.getGreen(), DataWindow.this.bgColor.getBlue(), DataWindow.this.backgroundtransparentvalue));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            AffineTransform trans = new AffineTransform();
            Object[] arr = DataWindow.this.elementsListModel.toArray();
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof AbstractElement)) continue;
                AbstractElement o = (AbstractElement)arr[i];
                if (o instanceof Transformation) {
                    if (i > 0 && arr[i - 1] instanceof DrawableElement) {
                        trans = new AffineTransform();
                    }
                    Transformation t = (Transformation)o;
                    trans.concatenate(t.getAffineTransform(this.getSize()));
                    continue;
                }
                if (!(o instanceof DrawableElement)) continue;
                g2d.setTransform(trans);
                DrawableElement d = (DrawableElement)o;
                d.drawTo(g2d, this.getSize());
            }
            g2d.setTransform(new AffineTransform());
            g2d.setColor(Color.BLACK);
            g2d.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, arcw, arch));
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof DefaultColorSelectionModel) {
                if (this.selected == this.bgChoose) {
                    DataWindow.this.bgColor = this.cc.getColor();
                    this.repaint();
                } else {
                    System.out.println(e.getSource());
                }
            }
        }
    }

    class MyListSelectionHandler
    implements ListSelectionListener {
        MyListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (DataWindow.this.getSelectedElement() != null) {
                DataWindow.this.elementsPanel.setRightComponent(new JScrollPane(DataWindow.this.getSelectedElement().getChangeComponent()));
            }
        }
    }
}

