/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.datatypes.BLData_t;
import de.mylifesucks.oss.ncsimulator.datatypes.Waypoint_t;
import de.mylifesucks.oss.ncsimulator.gui.CoordVizualizer;
import de.mylifesucks.oss.ncsimulator.gui.InfoPanel;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.DataWindowPanel;
import de.mylifesucks.oss.ncsimulator.protocol.Encode;
import de.mylifesucks.oss.ncsimulator.protocol.SendThread;
import de.mylifesucks.oss.ncsimulator.protocol.SerialComm;
import de.mylifesucks.oss.ncsimulator.protocol.TcpComm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MainPanel
extends JPanel {
    public static final String SERIALPORT = "Serial Port";
    public static final String TCPPORT = "Tcp Port";
    JButton start;
    JComboBox ports;
    JButton startTcp;
    JTextField tcpPort;
    JSlider timeSlider;
    CoordVizualizer cv;
    JTabbedPane tabbed = new JTabbedPane();
    public JCheckBox isUSB;
    public JCheckBox hasNC;
    public static final String requestOSD = "Request the NC-OSD dataset";
    public static final String stopOSD = "Stop requesting the NC-OSD dataset";
    public static final String requestDEBUG = "Request the FC-Debug dataset";
    public static final String stopDEBUG = "Stop requesting the FC-Debug dataset";

    public MainPanel() {
        super(new BorderLayout());
        this.add((Component)this.tabbed, "Center");
        Box configBox = Box.createVerticalBox();
        Box center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        this.ports = new JComboBox<Object>(SerialComm.getPorts().keySet().toArray());
        center.add(this.ports);
        String savedPort = DataStorage.preferences.get(SERIALPORT, "");
        this.ports.setSelectedItem(savedPort);
        this.isUSB = new JCheckBox("Is USB adapter?");
        center.add(this.isUSB);
        this.start = new JButton("start");
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MainPanel.this.ports.setEditable(false);
                    MainPanel.this.ports.setEnabled(false);
                    MainPanel.this.start.setEnabled(false);
                    DataStorage.preferences.put(MainPanel.SERIALPORT, MainPanel.this.ports.getSelectedItem().toString());
                    DataStorage.serial = new SerialComm(MainPanel.this.ports.getSelectedItem().toString(), MainPanel.this.isUSB.isSelected());
                    DataStorage.encoder = new Encode(DataStorage.serial.getOutputStream());
                    DataStorage.sendThread = new SendThread("Serial send Thread");
                    DataStorage.sendThread.start();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Start Error", 0);
                    MainPanel.this.ports.setEditable(false);
                    MainPanel.this.ports.setEnabled(false);
                    MainPanel.this.start.setEnabled(false);
                }
            }
        });
        center.add(this.start);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        this.tcpPort = new JTextField();
        this.tcpPort.setPreferredSize(new Dimension(80, this.tcpPort.getPreferredSize().height));
        this.tcpPort.setSize(this.tcpPort.getPreferredSize());
        this.tcpPort.setMaximumSize(this.tcpPort.getPreferredSize());
        this.tcpPort.setMinimumSize(this.tcpPort.getPreferredSize());
        this.tcpPort.setDocument(new ValueDocument());
        this.tcpPort.setText("64400");
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        center.add(this.tcpPort);
        this.startTcp = new JButton("start");
        this.startTcp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MainPanel.this.tcpPort.setEditable(false);
                    MainPanel.this.tcpPort.setEnabled(false);
                    MainPanel.this.startTcp.setEnabled(false);
                    DataStorage.preferences.put(MainPanel.TCPPORT, MainPanel.this.tcpPort.getText());
                    DataStorage.serial = new TcpComm(Integer.parseInt(MainPanel.this.tcpPort.getText()));
                    DataStorage.encoder = new Encode(DataStorage.serial.getOutputStream());
                    DataStorage.sendThread = new SendThread("Serial send Thread");
                    DataStorage.sendThread.start();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Start Error", 0);
                    MainPanel.this.tcpPort.setEditable(false);
                    MainPanel.this.tcpPort.setEnabled(false);
                    MainPanel.this.startTcp.setEnabled(false);
                }
            }
        });
        center.add(this.startTcp);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        JButton intervalForce = new JButton("Force OSD Data output 100ms");
        intervalForce.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataStorage.naviData.requestTime = 100L;
            }
        });
        center.add(intervalForce);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        final JButton requestButton = new JButton(requestOSD);
        requestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (requestButton.getText().equals(MainPanel.requestOSD)) {
                    DataStorage.requestOSDtime = 500;
                    requestButton.setText(MainPanel.stopOSD);
                } else {
                    DataStorage.requestOSDtime = 0;
                    requestButton.setText(MainPanel.requestOSD);
                }
            }
        });
        center.add(requestButton);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        this.hasNC = new JCheckBox("Has NaviCtrl?", DataStorage.hasNC);
        this.hasNC.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DataStorage.hasNC = MainPanel.this.hasNC.isSelected();
            }
        });
        center.add(this.hasNC);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        final JButton requestDebugButton = new JButton(requestDEBUG);
        requestDebugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (requestDebugButton.getText().equals(MainPanel.requestDEBUG)) {
                    DataStorage.requestDEBUGtime = 500;
                    requestDebugButton.setText(MainPanel.stopDEBUG);
                } else {
                    DataStorage.requestDEBUGtime = 0;
                    requestDebugButton.setText(MainPanel.requestDEBUG);
                }
            }
        });
        center.add(requestDebugButton);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        JPanel config = new JPanel();
        this.tabbed.addTab("Config", config);
        config.add(configBox);
        center = Box.createHorizontalBox();
        center.add(Box.createHorizontalGlue());
        final JButton save = new JButton("Save values");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == save) {
                    DataStorage.serializePool();
                }
            }
        });
        center.add(save);
        final JButton load = new JButton("Load values");
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == load) {
                    DataStorage.loadPool();
                }
            }
        });
        center.add(load);
        final JButton delte = new JButton("Delte saved values");
        delte.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == delte) {
                    DataStorage.deltePool();
                }
            }
        });
        center.add(delte);
        center.add(Box.createHorizontalGlue());
        configBox.add(center);
        if (DataStorage.naviData.Version.value == 0L) {
            DataStorage.naviData.Version.value = 5L;
        }
        this.tabbed.addTab("Log", DataStorage.logPanel);
        JPanel osdPanel = new JPanel(new GridBagLayout());
        GridBagConstraints osdgbc = new GridBagConstraints();
        ++osdgbc.gridy;
        DataStorage.naviData.addToPanel(osdPanel, osdgbc);
        JScrollPane osdScrollpane = new JScrollPane(osdPanel, 22, 30);
        this.tabbed.addTab("NC OSD Values", osdScrollpane);
        JPanel blPanel = new JPanel(new GridBagLayout());
        GridBagConstraints oblgbc = new GridBagConstraints();
        ++oblgbc.gridy;
        for (BLData_t bld : DataStorage.bldata_t) {
            ++oblgbc.gridy;
            oblgbc.gridx = 0;
            oblgbc.gridwidth = 0;
            blPanel.add((Component)new JLabel("BLCtrl #" + bld.Index.value), oblgbc);
            ++oblgbc.gridy;
            oblgbc.gridwidth = 1;
            bld.addToPanel(blPanel, oblgbc);
        }
        JScrollPane blScrollpane = new JScrollPane(blPanel, 22, 30);
        this.tabbed.addTab("BLCtrl", blScrollpane);
        DataStorage.clearWP();
        JPanel wpListPane = new JPanel();
        wpListPane.setLayout(new BoxLayout(wpListPane, 3));
        wpListPane.add(new JLabel("Label1"));
        wpListPane.add(new JLabel("Label1"));
        for (int i = 0; i < 10; ++i) {
            Waypoint_t wp = DataStorage.waypointList[i];
            JPanel wpPanel = new JPanel(new GridBagLayout());
            GridBagConstraints wpgbc = new GridBagConstraints();
            ++wpgbc.gridy;
            wp.addToPanel(wpPanel, wpgbc);
            wpListPane.add(wpPanel);
            wpListPane.add(new JLabel("Label1"));
        }
        wpListPane.add(new JLabel("Label1"));
        wpListPane.add(new JLabel("Label1"));
        JScrollPane waypointScrollpane = new JScrollPane(wpListPane, 22, 30);
        this.tabbed.addTab("Waypoints", waypointScrollpane);
        JPanel debugFCValPanel = new JPanel(new GridBagLayout());
        GridBagConstraints debuggcgbc = new GridBagConstraints();
        ++debuggcgbc.gridy;
        DataStorage.FCDebugOut.addToPanel(debugFCValPanel, debuggcgbc);
        JScrollPane debugFCScrollpane = new JScrollPane(debugFCValPanel, 22, 30);
        this.tabbed.addTab("FC Debug", debugFCScrollpane);
        JPanel ppmArrayPanel = new JPanel(new GridBagLayout());
        GridBagConstraints ppmArraygbc = new GridBagConstraints();
        ++ppmArraygbc.gridy;
        DataStorage.ppmarray.addToPanel(ppmArrayPanel, ppmArraygbc);
        JScrollPane ppmArrayScrollpane = new JScrollPane(ppmArrayPanel, 22, 30);
        this.tabbed.addTab("PPM", ppmArrayScrollpane);
        JPanel debugNCValPanel = new JPanel(new GridBagLayout());
        GridBagConstraints debugncgbc = new GridBagConstraints();
        ++debugncgbc.gridy;
        DataStorage.NCDebugOut.addToPanel(debugNCValPanel, debugncgbc);
        JScrollPane debugNCScrollpane = new JScrollPane(debugNCValPanel, 22, 30);
        this.tabbed.addTab("NC Debug", debugNCScrollpane);
        JPanel timePanel = new JPanel(new GridBagLayout());
        GridBagConstraints timePanelgbc = new GridBagConstraints();
        ++timePanelgbc.gridy;
        DataStorage.SystemTime.addToPanel(timePanel, timePanelgbc);
        JScrollPane timePanelgbcScrollpane = new JScrollPane(timePanel, 22, 30);
        this.tabbed.addTab("Time", timePanelgbcScrollpane);
        JTabbedPane paramPanel = new JTabbedPane();
        for (int i = 0; i < DataStorage.paramset.length; ++i) {
            JPanel setPanel = new JPanel(new GridBagLayout());
            GridBagConstraints paramgbc = new GridBagConstraints();
            ++paramgbc.gridy;
            DataStorage.paramset[i].addToPanel(setPanel, paramgbc);
            JScrollPane paramScrPanel = new JScrollPane(setPanel, 22, 30);
            paramPanel.add("Set " + DataStorage.paramset[i].index, paramScrPanel);
        }
        this.tabbed.addTab("Parameter", paramPanel);
        JPanel Val3dPanel = new JPanel(new GridBagLayout());
        GridBagConstraints val3dgbc = new GridBagConstraints();
        ++val3dgbc.gridy;
        DataStorage.str_Data3D.addToPanel(Val3dPanel, val3dgbc);
        JScrollPane val3dScrollpane = new JScrollPane(Val3dPanel, 22, 30);
        this.tabbed.addTab("3D (FC)", val3dScrollpane);
        JPanel Val3dncPanel = new JPanel(new GridBagLayout());
        GridBagConstraints val3dncgbc = new GridBagConstraints();
        ++val3dncgbc.gridy;
        DataStorage.data3d_t.addToPanel(Val3dncPanel, val3dncgbc);
        JScrollPane val3dncScrollpane = new JScrollPane(Val3dncPanel, 22, 30);
        this.tabbed.addTab("3D (NC)", val3dncScrollpane);
        DataStorage.FCversion.SWMajor.value = 0L;
        DataStorage.FCversion.SWMinor.value = 84L;
        DataStorage.FCversion.SWPatch.value = 0L;
        DataStorage.FCversion.ProtoMajor.value = 11L;
        DataStorage.FCversion.ProtoMinor.value = 0L;
        DataStorage.NCversion.SWMajor.value = 0L;
        DataStorage.NCversion.SWMinor.value = 24L;
        DataStorage.NCversion.SWPatch.value = 1L;
        DataStorage.NCversion.ProtoMajor.value = 11L;
        DataStorage.NCversion.ProtoMinor.value = 0L;
        DataStorage.MK3version.SWMajor.value = 0L;
        DataStorage.MK3version.SWMinor.value = 23L;
        DataStorage.MK3version.SWPatch.value = 0L;
        DataStorage.MK3version.ProtoMajor.value = 11L;
        DataStorage.MK3version.ProtoMinor.value = 0L;
        JPanel versionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints versiongbc = new GridBagConstraints();
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        versiongbc.gridwidth = 0;
        versionPanel.add((Component)new JLabel("FC"), versiongbc);
        versiongbc.gridwidth = 1;
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        DataStorage.FCversion.addToPanel(versionPanel, versiongbc);
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        versiongbc.gridwidth = 0;
        versionPanel.add((Component)new JLabel("NC"), versiongbc);
        versiongbc.gridwidth = 1;
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        DataStorage.NCversion.addToPanel(versionPanel, versiongbc);
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        versiongbc.gridwidth = 0;
        versionPanel.add((Component)new JLabel("MK3Mag"), versiongbc);
        versiongbc.gridwidth = 1;
        ++versiongbc.gridy;
        versiongbc.gridx = 0;
        DataStorage.MK3version.addToPanel(versionPanel, versiongbc);
        JScrollPane versionScroll = new JScrollPane(versionPanel, 22, 30);
        this.tabbed.addTab("Versions", versionScroll);
        JPanel lcdpanel = new JPanel(new GridBagLayout());
        GridBagConstraints lcdgbc = new GridBagConstraints();
        ++lcdgbc.gridy;
        DataStorage.lcddata.addToPanel(lcdpanel, lcdgbc);
        JScrollPane lcdScrollpane = new JScrollPane(lcdpanel, 22, 30);
        this.tabbed.addTab("LCD Text", lcdScrollpane);
        this.cv = DataStorage.coordVizualizer;
        this.tabbed.addTab("Coord Map", this.cv);
        JScrollPane dataWindowPanelgbcScroll = new JScrollPane(new DataWindowPanel(), 22, 30);
        this.tabbed.addTab("DataWindows", dataWindowPanelgbcScroll);
        this.tabbed.addTab("Information", new InfoPanel());
        this.tabbed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == MainPanel.this.tabbed && MainPanel.this.tabbed.getSelectedComponent() == MainPanel.this.cv) {
                    MainPanel.this.cv.update();
                }
            }
        });
        this.add((Component)DataStorage.statusBar, "South");
    }

    public class ValueDocument
    extends PlainDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str.length() == 0 || str.equals("")) {
                super.insertString(offs, str, a);
            } else if (str != null) {
                try {
                    Long.valueOf(str);
                    super.insertString(offs, str, a);
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }
    }
}

