/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.gui;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.datatypes.GPS_Deviation_t;
import de.mylifesucks.oss.ncsimulator.datatypes.GPS_Pos_t;
import de.mylifesucks.oss.ncsimulator.datatypes.c_int;
import de.mylifesucks.oss.ncsimulator.datatypes.s32;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.util.HashSet;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.jdesktop.swingx.painter.Painter;

public class CoordVizualizer
extends JPanel {
    JXMapKit mapKit;
    Waypoint home = new Waypoint();
    Waypoint target = new Waypoint();
    Waypoint current = new Waypoint();
    public static final double FACTOR = 1.0E7;
    public static final double M_PI_180 = Math.PI / 180;

    public CoordVizualizer() {
        super(new BorderLayout());
        this.mapKit = new JXMapKit();
        this.mapKit.setName("mapKit");
        this.mapKit.setPreferredSize(new Dimension(413, 218));
        this.add((Component)((Object)this.mapKit), "Center");
        this.mapKit.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        this.mapKit.setCenterPosition(new GeoPosition(54.4248, 10.1721));
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        waypoints.add(this.home);
        waypoints.add(this.current);
        waypoints.add(this.target);
        WaypointPainter painter = new WaypointPainter();
        painter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                Image icon = null;
                if (wp == CoordVizualizer.this.home) {
                    icon = DataStorage.iconHome.getImage();
                } else if (wp == CoordVizualizer.this.target) {
                    icon = DataStorage.iconTarget.getImage();
                } else if (wp == CoordVizualizer.this.current) {
                    icon = DataStorage.iconCurrent.getImage();
                }
                if (icon != null) {
                    g.drawImage(icon, AffineTransform.getTranslateInstance(-(icon.getWidth((ImageObserver)((Object)map)) / 2), -icon.getHeight((ImageObserver)((Object)map))), (ImageObserver)((Object)map));
                }
                return true;
            }
        });
        painter.setWaypoints(waypoints);
        this.mapKit.getMainMap().setOverlayPainter((Painter)painter);
        this.mapKit.getMainMap().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GeoPosition geopoint = CoordVizualizer.this.mapKit.getMainMap().convertPointToGeoPosition(e.getPoint());
                if (e.getClickCount() == 2) {
                    if (e.getButton() == 1) {
                        CoordVizualizer.setGeoPosition(geopoint, DataStorage.naviData.HomePosition.Latitude, DataStorage.naviData.HomePosition.Longitude);
                    }
                } else if (e.getButton() == 1) {
                    CoordVizualizer.setGeoPosition(geopoint, DataStorage.naviData.CurrentPosition.Latitude, DataStorage.naviData.CurrentPosition.Longitude);
                } else {
                    CoordVizualizer.setGeoPosition(geopoint, DataStorage.naviData.TargetPosition.Latitude, DataStorage.naviData.TargetPosition.Longitude);
                }
                CoordVizualizer.this.update();
            }
        });
    }

    public static double distance(GeoPosition a, GeoPosition b) {
        double b_lat = b.getLatitude();
        double a_lat = a.getLatitude();
        double b_long = b.getLongitude();
        double a_long = a.getLongitude();
        double eradius = 6378.137;
        double ret = Math.acos(Math.sin(b_lat / 180.0 * Math.PI) * Math.sin(a_lat / 180.0 * Math.PI) + Math.cos(b_lat / 180.0 * Math.PI) * Math.cos(a_lat / 180.0 * Math.PI) * Math.cos(b_long / 180.0 * Math.PI - a_long / 180.0 * Math.PI)) * eradius;
        return ret;
    }

    public static void setGeoPosition(GeoPosition geopoint, c_int Latitude, c_int Longitude) {
        Latitude.setValue((long)(geopoint.getLatitude() * 1.0E7), false);
        Longitude.setValue((long)(geopoint.getLongitude() * 1.0E7), true);
    }

    public static GeoPosition getGeoPosition(c_int Latitude, c_int Longitude) {
        return new GeoPosition((double)Latitude.value / 1.0E7, (double)Longitude.value / 1.0E7);
    }

    public static double DegFromGPS(s32 deg) {
        return (double)deg.value * (double)1.0E-7f;
    }

    public static double RadiansFromGPS(s32 deg) {
        return (double)deg.value * (double)1.0E-7f * (Math.PI / 180);
    }

    public static long DirectionToTarget_N_E(double northdev, double eastdev) {
        long bearing = (long)(Math.atan2(northdev, eastdev) / (Math.PI / 180));
        bearing = (270L - bearing) % 360L;
        return bearing;
    }

    public static GPS_Deviation_t GPS_CalculateDeviation(GPS_Pos_t pCurrentPos, GPS_Pos_t pTargetPos) {
        GPS_Deviation_t TargetDeviation = new GPS_Deviation_t();
        double temp1 = CoordVizualizer.DegFromGPS(pCurrentPos.Longitude) - CoordVizualizer.DegFromGPS(pTargetPos.Longitude);
        if (temp1 > 180.0) {
            temp1 -= 360.0;
        } else if (temp1 < -180.0) {
            temp1 += 360.0;
        }
        double temp2 = CoordVizualizer.DegFromGPS(pCurrentPos.Latitude) - CoordVizualizer.DegFromGPS(pTargetPos.Latitude);
        TargetDeviation.North.value = (long)(1.1119493E7 * temp2);
        TargetDeviation.East.value = (long)(1.1119493E7 * (temp1 *= Math.cos(CoordVizualizer.RadiansFromGPS(pTargetPos.Latitude))));
        TargetDeviation.Distance.value = (long)(1.1119493E7 * Math.hypot(temp1, temp2));
        TargetDeviation.Bearing.value = TargetDeviation.Distance.value == 0L ? 0L : CoordVizualizer.DirectionToTarget_N_E(temp2, temp1);
        return TargetDeviation;
    }

    public void update() {
        this.home.setPosition(CoordVizualizer.getGeoPosition(DataStorage.naviData.HomePosition.Latitude, DataStorage.naviData.HomePosition.Longitude));
        this.current.setPosition(CoordVizualizer.getGeoPosition(DataStorage.naviData.CurrentPosition.Latitude, DataStorage.naviData.CurrentPosition.Longitude));
        this.target.setPosition(CoordVizualizer.getGeoPosition(DataStorage.naviData.TargetPosition.Latitude, DataStorage.naviData.TargetPosition.Longitude));
        GPS_Deviation_t targetDev = CoordVizualizer.GPS_CalculateDeviation(DataStorage.naviData.CurrentPosition, DataStorage.naviData.HomePosition);
        DataStorage.naviData.HomePositionDeviation.Bearing.value = targetDev.Bearing.value;
        targetDev = CoordVizualizer.GPS_CalculateDeviation(DataStorage.naviData.CurrentPosition, DataStorage.naviData.TargetPosition);
        DataStorage.naviData.TargetPositionDeviation.Bearing.value = targetDev.Bearing.value;
        DataStorage.naviData.HomePositionDeviation.Distance.setValue((long)(10000.0 * CoordVizualizer.distance(CoordVizualizer.getGeoPosition(DataStorage.naviData.CurrentPosition.Latitude, DataStorage.naviData.CurrentPosition.Longitude), CoordVizualizer.getGeoPosition(DataStorage.naviData.HomePosition.Latitude, DataStorage.naviData.HomePosition.Longitude))), false);
        DataStorage.naviData.TargetPositionDeviation.Distance.setValue((long)(10000.0 * CoordVizualizer.distance(CoordVizualizer.getGeoPosition(DataStorage.naviData.CurrentPosition.Latitude, DataStorage.naviData.CurrentPosition.Longitude), CoordVizualizer.getGeoPosition(DataStorage.naviData.TargetPosition.Latitude, DataStorage.naviData.TargetPosition.Longitude))), true);
        this.mapKit.getMainMap().repaint();
    }
}

