/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.datatypes;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class c_int
extends Observable {
    static final int LABELWIDTH = 120;
    public boolean signed;
    public int length = 0;
    public long value = 0L;
    public volatile long requestTime = -1L;
    public String name;
    JSlider slider;
    JTextField valueField;
    public JComponent nameLabel = null;
    public LinkedList<c_int> allAttribs = null;
    protected Integer minValue;
    protected Integer maxValue;

    public LinkedList<c_int> getList() {
        LinkedList<c_int> poss = new LinkedList<c_int>();
        if (this.allAttribs == null) {
            poss.add(this);
        } else {
            for (c_int c : this.allAttribs) {
                poss.addAll(c.getList());
            }
        }
        return poss;
    }

    public int getMin() {
        if (!this.signed) {
            return 0;
        }
        if (this.minValue != null) {
            return this.minValue;
        }
        return (int)(-Math.pow(2.0, this.length - 1));
    }

    public int getLength() {
        if (this.allAttribs == null) {
            return this.length;
        }
        int len = 0;
        for (c_int c : this.allAttribs) {
            len += c.getLength();
        }
        return len;
    }

    public String toString() {
        return this.getSerializeName();
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        if (this.allAttribs != null && this.allAttribs.size() > 0) {
            for (c_int c : this.allAttribs) {
                c.addObserver(o);
            }
        }
    }

    public void loadFromInt(int[] RxdBuffer, int pRxData) {
        if (this.allAttribs != null && this.allAttribs.size() > 0) {
            int offset = 0;
            for (c_int c : this.allAttribs) {
                c.loadFromInt(RxdBuffer, pRxData + offset);
                offset += c.getLength() / 8;
            }
            Runnable r = new Runnable(){

                public void run() {
                    c_int.this.setChanged();
                    c_int.this.notifyObservers();
                }
            };
            DataStorage.executors.submit(r);
        } else {
            long v = 0L;
            if (pRxData + this.getLength() / 8 <= RxdBuffer.length) {
                for (int i = this.length / 8 - 1; i >= 0; --i) {
                    v <<= 8;
                    v |= (long)RxdBuffer[i + pRxData];
                }
                if (this.signed) {
                    long signmask = 1 << this.getLength() - 1;
                    long signbit = (v & signmask) != 0L ? 1L : 0L;
                    v &= signmask ^ 0xFFFFFFFFFFFFFFFFL;
                    if (signbit == 1L) {
                        v += (long)this.getMin();
                    }
                }
                this.setValue(v, false);
            }
        }
    }

    public String getSerializeName() {
        return this.name;
    }

    public int getMax() {
        if (this.maxValue != null) {
            return this.maxValue;
        }
        if (!this.signed) {
            return (int)(Math.pow(2.0, this.length) - 1.0);
        }
        return (int)(Math.pow(2.0, this.length - 1) - 1.0);
    }

    public void setValue(long value, boolean notify) {
        this.value = value;
        if (this.valueField != null) {
            this.valueField.setText("" + value);
        }
        if (notify) {
            Runnable r = new Runnable(){

                public void run() {
                    c_int.this.setChanged();
                    c_int.this.notifyObservers();
                }
            };
            DataStorage.executors.submit(r);
        }
    }

    public static byte[] getbytes(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return data;
    }

    public int[] getAsInt() {
        if (this.allAttribs == null) {
            int[] ret = new int[this.length / 8];
            for (int i = 0; i < ret.length; ++i) {
                ret[ret.length - 1 - i] = (char)(0xFFL & this.value >> (ret.length - i - 1) * 8);
            }
            return ret;
        }
        int[] ret = new int[]{};
        for (c_int o : this.allAttribs) {
            ret = c_int.concatArray(ret, o.getAsInt());
        }
        return ret;
    }

    protected void initComponent() {
        DataStorage.addToSerializePool(this);
        this.slider = new JSlider(0, this.getMin(), this.getMax(), Math.min(this.getMax(), (int)this.value));
        this.slider.setMinimumSize(new Dimension(120, this.slider.getPreferredSize().height));
        this.valueField = new JTextField();
        this.valueField.setPreferredSize(new Dimension(120, this.valueField.getPreferredSize().height));
        this.valueField.setSize(this.valueField.getPreferredSize());
        this.valueField.setMaximumSize(this.valueField.getPreferredSize());
        this.valueField.setMinimumSize(this.valueField.getPreferredSize());
        this.valueField.setDocument(new ValueDocument());
        this.valueField.setText("" + this.value);
        ChangeListener myCL = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == c_int.this.slider) {
                    c_int.this.value = c_int.this.slider.getValue();
                    c_int.this.setValue(c_int.this.value, true);
                } else if (e.getSource() == c_int.this.valueField) {
                    System.out.println(e);
                }
            }
        };
        this.slider.addChangeListener(myCL);
    }

    private void doUpSrcText() {
        try {
            long val = Long.valueOf(this.valueField.getText());
            if (val >= (long)this.getMin() && val <= (long)this.getMax()) {
                this.slider.setValue((int)val);
                this.value = val;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected JComponent getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel(this.name);
        }
        return this.nameLabel;
    }

    public synchronized void addToPanel(JComponent panel, GridBagConstraints gbc) {
        if (this.nameLabel == null) {
            this.initComponent();
        }
        if (this.allAttribs == null) {
            gbc.gridx = 0;
            panel.add((Component)this.getNameLabel(), gbc);
            ++gbc.gridx;
            gbc.fill = 2;
            panel.add((Component)this.valueField, gbc);
            gbc.fill = 0;
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            panel.add((Component)this.slider, gbc);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            ++gbc.gridy;
        } else {
            for (c_int foo : this.allAttribs) {
                foo.addToPanel(panel, gbc);
            }
        }
    }

    public void printOut() {
        if (this.allAttribs != null) {
            for (c_int c : this.allAttribs) {
                c.printOut();
            }
        } else {
            System.out.println(this.name + "\t" + this.value);
        }
    }

    public static int[] concatArray(int[] a, int[] b) {
        int i;
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        int[] ret = new int[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        for (i = a.length; i < a.length + b.length; ++i) {
            ret[i] = b[i - a.length];
        }
        return ret;
    }

    public static String paddingString(String s, int n, char c, boolean paddingLeft) {
        if (s == null) {
            return s;
        }
        int add = n - s.length();
        if (add <= 0) {
            return s;
        }
        StringBuffer str = new StringBuffer(s);
        char[] ch = new char[add];
        Arrays.fill(ch, c);
        if (paddingLeft) {
            str.insert(0, ch);
        } else {
            str.append(ch);
        }
        return str.toString();
    }

    public void dump() {
        System.out.println(this.name + ": " + this.value);
        for (c_int c : this.allAttribs) {
            c.dump();
        }
    }

    public class ValueDocument
    extends PlainDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str.length() == 0 || str.equals("")) {
                super.insertString(offs, str, a);
                c_int.this.doUpSrcText();
            } else if (str != null) {
                try {
                    Long.valueOf(str);
                    super.insertString(offs, str, a);
                    c_int.this.doUpSrcText();
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            c_int.this.doUpSrcText();
        }
    }
}

