/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator.datastorage;

import de.mylifesucks.oss.ncsimulator.datatypes.BLData_t;
import de.mylifesucks.oss.ncsimulator.datatypes.Data3D_t;
import de.mylifesucks.oss.ncsimulator.datatypes.DateTime_t;
import de.mylifesucks.oss.ncsimulator.datatypes.LCDData;
import de.mylifesucks.oss.ncsimulator.datatypes.MixerTable_t;
import de.mylifesucks.oss.ncsimulator.datatypes.NaviData_t;
import de.mylifesucks.oss.ncsimulator.datatypes.PPMArray;
import de.mylifesucks.oss.ncsimulator.datatypes.Waypoint_t;
import de.mylifesucks.oss.ncsimulator.datatypes.c_int;
import de.mylifesucks.oss.ncsimulator.datatypes.paramset_t;
import de.mylifesucks.oss.ncsimulator.datatypes.s16Debug;
import de.mylifesucks.oss.ncsimulator.datatypes.str_Data3D;
import de.mylifesucks.oss.ncsimulator.datatypes.str_DebugOut;
import de.mylifesucks.oss.ncsimulator.datatypes.str_VersionInfo;
import de.mylifesucks.oss.ncsimulator.gui.CoordVizualizer;
import de.mylifesucks.oss.ncsimulator.gui.LogPanel;
import de.mylifesucks.oss.ncsimulator.gui.StatusBar;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.DataWindow;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.DataWindowPanel;
import de.mylifesucks.oss.ncsimulator.protocol.CommunicationBase;
import de.mylifesucks.oss.ncsimulator.protocol.Encode;
import de.mylifesucks.oss.ncsimulator.protocol.SendThread;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JTextField;

public class DataStorage {
    public static volatile int requestOSDtime;
    public static volatile int requestDEBUGtime;
    public static ExecutorService executors;
    public static ImageIcon iconHome;
    public static ImageIcon iconCurrent;
    public static ImageIcon iconTarget;
    public static ImageIcon mainLogo;
    public static NaviData_t naviData;
    public static str_VersionInfo NCversion;
    public static str_VersionInfo FCversion;
    public static str_VersionInfo MK3version;
    public static str_DebugOut FCDebugOut;
    public static str_DebugOut NCDebugOut;
    public static str_DebugOut MK3MAGDebugOut;
    public static paramset_t[] paramset;
    public static int activeParamset;
    public static Waypoint_t[] waypointList;
    public static PPMArray ppmarray;
    public static MixerTable_t mixerset;
    public static LCDData lcddata;
    public static str_Data3D str_Data3D;
    public static Data3D_t data3d_t;
    public static BLData_t[] bldata_t;
    public static Preferences preferences;
    public static Encode encoder;
    public static DateTime_t SystemTime;
    public static CommunicationBase serial;
    private static DataStorage instance;
    private static LinkedList<c_int> serializePool;
    public static SendThread sendThread;
    public static volatile UART_CONNECTION UART;
    public static CoordVizualizer coordVizualizer;
    public static StatusBar statusBar;
    public static LogPanel logPanel;
    public static LinkedList<DataWindow> dataWindows;
    public static final String nodeName = "NC Simulator";
    public static DataWindowPanel dataWindowPanel;
    public static int motorCounter;
    public static boolean hasNC;

    private DataStorage() {
        int i;
        iconHome = new ImageIcon(this.getClass().getResource("/de/mylifesucks/oss/ncsimulator/img/home.png"));
        iconCurrent = new ImageIcon(this.getClass().getResource("/de/mylifesucks/oss/ncsimulator/img/airport.png"));
        iconTarget = new ImageIcon(this.getClass().getResource("/de/mylifesucks/oss/ncsimulator/img/target.png"));
        mainLogo = new ImageIcon(this.getClass().getResource("/de/mylifesucks/oss/ncsimulator/img/logo_big.png"));
        serializePool = new LinkedList();
        preferences = Preferences.userRoot().node(nodeName);
        if (paramset == null || paramset[0] == null) {
            paramset = new paramset_t[5];
            for (i = 0; i < paramset.length; ++i) {
                DataStorage.paramset[i] = new paramset_t(i + 1);
            }
        }
        if (bldata_t == null || bldata_t[0] == null) {
            bldata_t = new BLData_t[12];
            for (i = 0; i < bldata_t.length; ++i) {
                DataStorage.bldata_t[i] = new BLData_t(i);
            }
        }
        if (waypointList == null || waypointList[0] == null) {
            waypointList = new Waypoint_t[400];
            for (i = 0; i < waypointList.length; ++i) {
                DataStorage.waypointList[i] = DataStorage.getEmptyWP(i + 1);
            }
        }
    }

    public static void clearWP() {
    }

    public static Waypoint_t getEmptyWP(int index) {
        Waypoint_t wp = new Waypoint_t("WP" + index);
        wp.Position.Status.value = 0L;
        wp.Position.Latitude.value = 0L;
        wp.Position.Longitude.value = 0L;
        wp.Position.Altitude.value = 0L;
        wp.Heading.value = 361L;
        wp.ToleranceRadius.value = 0L;
        wp.HoldTime.value = 0L;
        wp.Type.value = 255L;
        wp.Event_Flag.value = 0L;
        wp.AltitudeRate.value = 0L;
        wp.Speed.value = 30L;
        wp.CameraAngle.value = 0L;
        wp.Index.value = index + 1;
        return wp;
    }

    public static void addWP(Waypoint_t wp) {
        int wpIndex = (int)wp.Index.value - 1;
        System.out.println("Add WP " + wp.Index.value);
        wp.printOut();
        DataStorage.waypointList[wpIndex] = wp;
    }

    public static synchronized DataStorage getInstance() {
        if (instance == null) {
            instance = new DataStorage();
        }
        return instance;
    }

    public static void setUART(UART_CONNECTION u) {
        if (u != UART_CONNECTION.NC || u == UART_CONNECTION.NC && hasNC) {
            UART = u;
        }
        DataStorage.statusBar.uartMode.setText(UART.name());
    }

    public static void addToSerializePool(c_int re) {
        DataStorage.getInstance();
        if (re.allAttribs == null) {
            serializePool.add(re);
            re.setValue(preferences.getLong(re.getSerializeName(), re.value), false);
        } else {
            for (c_int c : re.allAttribs) {
                if (re.allAttribs != null || c.getSerializeName() == null) {
                    DataStorage.addToSerializePool(c);
                    continue;
                }
                serializePool.add(c);
                c.setValue(preferences.getLong(c.getSerializeName(), c.value), false);
            }
        }
    }

    public static void serializePool() {
        for (c_int c : serializePool) {
            preferences.putLong(c.getSerializeName(), c.value);
            if (!(c instanceof s16Debug)) continue;
            s16Debug s = (s16Debug)c;
            preferences.put(s.getSerializeName() + "LABEL", ((JTextField)s.nameLabel).getText());
        }
    }

    public static void loadPool() {
        for (c_int c : serializePool) {
            c.setValue(preferences.getLong(c.getSerializeName(), c.value), false);
            if (!(c instanceof s16Debug)) continue;
            s16Debug s = (s16Debug)c;
            s.setName(preferences.get(s.getSerializeName() + "LABEL", ((JTextField)s.nameLabel).getText()));
        }
    }

    public static void deltePool() {
        try {
            preferences.removeNode();
            preferences = Preferences.userRoot().node(nodeName);
            System.out.println("deleted");
        }
        catch (BackingStoreException ex) {
            System.err.println("delete fail");
        }
    }

    static {
        executors = Executors.newCachedThreadPool();
        naviData = new NaviData_t();
        NCversion = new str_VersionInfo("NC");
        FCversion = new str_VersionInfo("FC");
        MK3version = new str_VersionInfo("MK3Mag");
        FCDebugOut = new str_DebugOut("FC", 1);
        NCDebugOut = new str_DebugOut("NC", 2);
        MK3MAGDebugOut = new str_DebugOut("MK3MAG", 3);
        paramset = new paramset_t[5];
        activeParamset = 3;
        waypointList = new Waypoint_t[250];
        ppmarray = new PPMArray();
        mixerset = new MixerTable_t();
        lcddata = new LCDData();
        str_Data3D = new str_Data3D();
        data3d_t = new Data3D_t();
        bldata_t = new BLData_t[12];
        SystemTime = new DateTime_t();
        instance = new DataStorage();
        UART = UART_CONNECTION.NC;
        coordVizualizer = new CoordVizualizer();
        statusBar = new StatusBar();
        logPanel = new LogPanel();
        dataWindows = new LinkedList();
        motorCounter = 0;
        hasNC = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UART_CONNECTION {
        FC,
        MK3MAG,
        MKGPS,
        NC;

    }
}

