/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.ncsimulator;

import de.mylifesucks.oss.ncsimulator.datastorage.DataStorage;
import de.mylifesucks.oss.ncsimulator.gui.MainPanel;
import de.mylifesucks.oss.ncsimulator.gui.datawindow.DataWindow;
import de.mylifesucks.oss.ncsimulator.gui.tray.SimTray;
import de.mylifesucks.oss.ncsimulator.protocol.SerialComm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class Main
extends JFrame {
    public static MainPanel vPanel;
    private static SplashScreen mySplash;
    private static Rectangle2D.Double splashTextArea;
    private static Graphics2D splashGraphics;
    private static Rectangle2D.Double splashProgressArea;
    public static final String mainFrameW = "MainFrame Width";
    public static final String mainFrameH = "MainFrame Height";
    public static final String mainFramePX = "MainFrame Position X";
    public static final String mainFramePY = "MainFrame Position Y";
    public static final String title = "NC Simulator by CaScAdE";
    public static final String version = "2013XXXX-XXXX";

    Main() {
        super("NC Simulator by CaScAdE Version: 2013XXXX-XXXX");
        this.setLayout(new BorderLayout());
        vPanel = new MainPanel();
        this.setIconImage(DataStorage.mainLogo.getImage());
        this.add((Component)vPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DataStorage.preferences.putInt(Main.mainFrameW, Main.this.getWidth());
                DataStorage.preferences.putInt(Main.mainFrameH, Main.this.getHeight());
                DataStorage.preferences.putInt(Main.mainFramePX, Main.this.getLocation().x);
                DataStorage.preferences.putInt(Main.mainFramePY, Main.this.getLocation().y);
                System.exit(0);
            }
        });
        this.pack();
        this.setSize(new Dimension((int)Math.min((double)this.getWidth(), Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 100.0), Math.min(this.getHeight(), 500)));
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
        this.setSize(DataStorage.preferences.getInt(mainFrameW, this.getWidth()), DataStorage.preferences.getInt(mainFrameH, this.getHeight()));
        this.setLocation(DataStorage.preferences.getInt(mainFramePX, this.getLocation().x), DataStorage.preferences.getInt(mainFramePY, this.getLocation().y));
        SimTray.mainFrame = this;
        SimTray.getInstance();
    }

    private static void initSplashScreen() {
        mySplash = SplashScreen.getSplashScreen();
        if (mySplash != null) {
            int fontsize = 14;
            splashTextArea = new Rectangle2D.Double(133.0, 179.0, 151.0, fontsize + 3);
            splashProgressArea = new Rectangle2D.Double(55.0, 236.0, 227.0, 7.0);
            splashGraphics = mySplash.createGraphics();
            splashGraphics.setFont(new Font("Dialog", 0, fontsize));
            Main.drawSplashMessage("Starting");
            Main.drawSplashProgressBar(0);
        }
    }

    public static void drawSplashProgressBar(int pct) {
        if (mySplash != null && mySplash.isVisible()) {
            splashGraphics.setPaint(Color.BLACK);
            splashGraphics.draw(splashProgressArea);
            int x = (int)splashProgressArea.getMinX();
            int y = (int)splashProgressArea.getMinY();
            int wid = (int)splashProgressArea.getWidth();
            int hgt = (int)splashProgressArea.getHeight();
            int doneWidth = Math.round((float)(pct * wid) / 100.0f);
            doneWidth = Math.max(0, Math.min(doneWidth, wid - 1));
            splashGraphics.setPaint(Color.RED);
            splashGraphics.fillRect(x + 1, y + 1, doneWidth, hgt - 1);
            mySplash.update();
        }
    }

    public static void drawSplashMessage(String str) {
        if (mySplash != null && mySplash.isVisible()) {
            splashGraphics.setPaint(Color.WHITE);
            splashGraphics.fill(splashTextArea);
            splashGraphics.setPaint(Color.BLACK);
            splashGraphics.setFont(splashGraphics.getFont().deriveFont(12.0f));
            splashGraphics.drawString(str, (int)(splashTextArea.getX() + 5.0), (int)(splashTextArea.getY() + 12.0));
            mySplash.update();
        }
    }

    public static void main(String[] args) {
        Main.initSplashScreen();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Main.drawSplashProgressBar(20);
        Main.drawSplashMessage("Initializing DataStorage");
        DataStorage.getInstance();
        Main.drawSplashProgressBar(40);
        Main.drawSplashMessage("Detecting Serial Ports");
        SerialComm.getPorts();
        Main.drawSplashProgressBar(60);
        Main.drawSplashMessage("Initializing MainFrame");
        Main main = new Main();
        Main.drawSplashProgressBar(75);
        Main.drawSplashMessage("Initializing DataWindows");
        DataWindow.init();
        Main.drawSplashProgressBar(99);
        Main.drawSplashMessage("Nearly done");
        Main.drawSplashProgressBar(100);
        Main.drawSplashMessage("Done");
        main.setVisible(true);
        main.toFront();
        if (mySplash != null && mySplash.isVisible()) {
            mySplash.close();
        }
    }
}

