/*
 * Decompiled with CFR 0.152.
 */
package de.mylifesucks.oss.graphichelpers;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class DrawStringHelpers {
    public static void drawStringBiggest(Graphics2D g2d, Dimension dim, String drawString) {
        Rectangle2D bounds;
        Object KEY_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object KEY_TEXT_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        int fontsize = (int)Math.max(6.0, Math.ceil(dim.getWidth() / (double)drawString.length()) * 3.0);
        fontsize = Math.min(fontsize, (int)Math.ceil(dim.getHeight() * 1.3));
        float posx = 0.0f;
        float posy = 0.0f;
        do {
            g2d.setFont(g2d.getFont().deriveFont(0, fontsize -= 5));
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout tl = new TextLayout(drawString, g2d.getFont(), frc);
            bounds = tl.getBounds();
            posx = (float)(dim.getWidth() / 2.0 - bounds.getCenterX());
            posy = (float)(dim.getHeight() / 2.0 - bounds.getCenterY());
        } while ((bounds.getMaxX() + (double)posx > dim.getWidth() || bounds.getMaxY() + (double)posy > dim.getHeight() || bounds.getMinY() + (double)posy < 0.0 || bounds.getMinX() + (double)posx < 0.0) && fontsize > 5);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, KEY_ANTIALIASING_before);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, KEY_TEXT_ANTIALIASING_before);
        g2d.drawString(drawString, (int)posx, (int)posy);
    }

    public static void drawStringCentered(Graphics2D g2d, Dimension dim, String drawString, int fontSize) {
        Object KEY_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object KEY_TEXT_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float posx = 0.0f;
        float posy = 0.0f;
        g2d.setFont(g2d.getFont().deriveFont(0, fontSize));
        FontRenderContext frc = g2d.getFontRenderContext();
        TextLayout tl = new TextLayout(drawString, g2d.getFont(), frc);
        Rectangle2D bounds = tl.getBounds();
        posx = (float)(dim.getWidth() / 2.0 - bounds.getCenterX());
        posy = (float)(dim.getHeight() / 2.0 - bounds.getCenterY());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, KEY_ANTIALIASING_before);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, KEY_TEXT_ANTIALIASING_before);
        g2d.drawString(drawString, (int)posx, (int)posy);
    }

    public static void drawStringAtPos(Graphics2D g2d, Dimension dim, String drawString, int fontSize, double x, boolean xpercent, double y, boolean ypercent) {
        Object KEY_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object KEY_TEXT_ANTIALIASING_before = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float posx = 0.0f;
        float posy = 0.0f;
        g2d.setFont(g2d.getFont().deriveFont(0, fontSize));
        FontRenderContext frc = g2d.getFontRenderContext();
        TextLayout tl = new TextLayout(drawString, g2d.getFont(), frc);
        Rectangle2D bounds = tl.getBounds();
        double xfactor = 1.0;
        if (xpercent) {
            xfactor = dim.getWidth() / 100.0;
        }
        double yfactor = 1.0;
        if (ypercent) {
            yfactor = dim.getHeight() / 100.0;
        }
        posx = (float)(x * xfactor - bounds.getCenterX());
        posy = (float)(y * yfactor - bounds.getCenterY());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, KEY_ANTIALIASING_before);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, KEY_TEXT_ANTIALIASING_before);
        g2d.drawString(drawString, (int)posx, (int)posy);
    }
}

